
import gurobipy as gp

# Create a new model
model = gp.Model("office_supplies")

# Create variables
paper = model.addVar(vtype=gp.GRB.INTEGER, name="paper")
highlighters = model.addVar(vtype=gp.GRB.INTEGER, name="highlighters")
hole_punches = model.addVar(vtype=gp.GRB.INTEGER, name="hole_punches")
pens = model.addVar(vtype=gp.GRB.INTEGER, name="pens")

# Set objective function
model.setObjective(6.04 * paper + 7.53 * highlighters + 4.52 * hole_punches + 6.92 * pens, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(12 * highlighters + 2 * hole_punches + 24 * pens >= 103)
model.addConstr(12 * paper + 12 * highlighters + 24 * pens >= 103)
model.addConstr(12 * paper + 12 * highlighters + 2 * hole_punches >= 103)
model.addConstr(12 * paper + 2 * hole_punches + 24 * pens >= 103)
model.addConstr(12 * highlighters + 2 * hole_punches + 24 * pens >= 75)
model.addConstr(12 * paper + 12 * highlighters + 24 * pens >= 75)
model.addConstr(12 * paper + 12 * highlighters + 2 * hole_punches >= 75)
model.addConstr(12 * paper + 2 * hole_punches + 24 * pens >= 75)
model.addConstr(12 * highlighters + 2 * hole_punches + 24 * pens >= 102)
model.addConstr(12 * paper + 12 * highlighters + 24 * pens >= 102)
model.addConstr(12 * paper + 12 * highlighters + 2 * hole_punches >= 102)
model.addConstr(12 * paper + 2 * hole_punches + 24 * pens >= 102)
model.addConstr(12 * highlighters + 2 * hole_punches + 24 * pens >= 91)
model.addConstr(12 * paper + 12 * highlighters + 24 * pens >= 91)
model.addConstr(12 * paper + 12 * highlighters + 2 * hole_punches >= 91)
model.addConstr(12 * paper + 2 * hole_punches + 24 * pens >= 91)
model.addConstr(25 * paper + 12 * hole_punches <= 203)
model.addConstr(25 * paper + 29 * pens <= 229)
model.addConstr(1 * highlighters + 12 * hole_punches <= 527)
model.addConstr(25 * paper + 1 * highlighters <= 552)
model.addConstr(1 * highlighters + 29 * pens <= 374)
model.addConstr(25 * paper + 12 * hole_punches + 29 * pens <= 465)
model.addConstr(1 * highlighters + 12 * hole_punches + 29 * pens <= 193)
model.addConstr(25 * paper + 1 * highlighters + 12 * hole_punches + 29 * pens <= 193)
model.addConstr(2 * hole_punches + 24 * pens <= 495)
model.addConstr(12 * highlighters + 2 * hole_punches <= 509)
model.addConstr(12 * paper + 2 * hole_punches <= 208)
model.addConstr(12 * highlighters + 2 * hole_punches + 24 * pens <= 179)
model.addConstr(12 * paper + 12 * highlighters + 2 * hole_punches + 24 * pens <= 179)


model.addConstr(25 * paper + 1 * highlighters + 12 * hole_punches + 29 * pens <= 637)
model.addConstr(12 * paper + 12 * highlighters + 2 * hole_punches + 24 * pens <= 517)



# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal objective value: {model.objVal}")
    print("Variable values:")
    for v in model.getVars():
        print(f"{v.varName}: {v.x}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

