
import gurobi

# Create a new Gurobi model
m = gurobi.Model()

# Define the variables
x0 = m.addVar(vtype=gurobi.GRB.INTEGER, name='x0') # packs of paper
x1 = m.addVar(vtype=gurobi.GRB.INTEGER, name='x1') # yellow highlighters
x2 = m.addVar(vtype=gurobi.GRB.INTEGER, name='x2') # hole punches
x3 = m.addVar(vtype=gurobi.GRB.INTEGER, name='x3') # black pens

# Set the objective function
m.setObjective(6.04 * x0 + 7.53 * x1 + 4.52 * x2 + 6.92 * x3, gurobi.GRB.MAXIMIZE)

# Add constraints
m.addConstr(x0 == 25, name='c1')
m.addConstr(12 * x0 + 12 * x1 + 2 * x2 + 24 * x3 >= 103, name='c2')
m.addConstr(12 * x0 + 12 * x1 + 24 * x3 >= 103, name='c3')
m.addConstr(12 * x0 + 12 * x1 + 2 * x2 >= 103, name='c4')
m.addConstr(12 * x0 + 2 * x2 + 24 * x3 >= 103, name='c5')
m.addConstr(12 * x1 + 2 * x2 + 24 * x3 >= 75, name='c6')
m.addConstr(12 * x0 + 12 * x1 + 24 * x3 >= 75, name='c7')
m.addConstr(12 * x0 + 12 * x1 + 2 * x2 >= 75, name='c8')
m.addConstr(12 * x0 + 2 * x2 + 24 * x3 >= 75, name='c9')
m.addConstr(12 * x1 + 2 * x2 + 24 * x3 >= 102, name='c10')
m.addConstr(12 * x0 + 12 * x1 + 24 * x3 >= 102, name='c11')
m.addConstr(12 * x0 + 12 * x1 + 2 * x2 >= 102, name='c12')
m.addConstr(12 * x0 + 2 * x2 + 24 * x3 >= 102, name='c13')
m.addConstr(12 * x1 + 2 * x2 + 24 * x3 >= 91, name='c14')
m.addConstr(12 * x0 + 12 * x1 + 24 * x3 >= 91, name='c15')
m.addConstr(12 * x0 + 12 * x1 + 2 * x2 >= 91, name='c16')
m.addConstr(12 * x0 + 2 * x2 + 24 * x3 >= 91, name='c17')
m.addConstr(25 * x0 + 12 * x2 <= 203, name='c18')
m.addConstr(25 * x0 + 29 * x3 <= 229, name='c19')
m.addConstr(x1 + 12 * x2 <= 527, name='c20')
m.addConstr(25 * x0 + x1 <= 552, name='c21')
m.addConstr(x1 + 29 * x3 <= 374, name='c22')
m.addConstr(25 * x0 + 12 * x2 + 29 * x3 <= 465, name='c23')
m.addConstr(x1 + 12 * x2 + 29 * x3 <= 193, name='c24')
m.addConstr(25 * x0 + x1 + 12 * x2 + 29 * x3 <= 193, name='c25')
m.addConstr(2 * x2 + 24 * x3 <= 495, name='c26')
m.addConstr(12 * x1 + 2 * x2 <= 509, name='c27')
m.addConstr(12 * x0 + 2 * x2 <= 208, name='c28')
m.addConstr(12 * x1 + 2 * x2 + 24 * x3 <= 179, name='c29')
m.addConstr(12 * x0 + 12 * x1 + 2 * x2 + 24 * x3 <= 179, name='c30')

# Solve the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print('Objective: ', m.objVal)
    print('x0: ', x0.varValue)
    print('x1: ', x1.varValue)
    print('x2: ', x2.varValue)
    print('x3: ', x3.varValue)
else:
    print('The model is infeasible')
