
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
x0 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="chicken_drumsticks")
x1 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="potatoes")
x2 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="bananas")
x3 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="granola_bars")
x4 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="chicken_breasts")


# Set objective function
m.setObjective(2*x0 + 9*x1 + 9*x2 + 5*x3 + 2*x4, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(4*x0 + 5*x1 + 10*x2 + 11*x3 + 9*x4 <= 234, "protein_constraint")
m.addConstr(2*x0 + 14*x1 + 14*x2 + 6*x3 + 2*x4 <= 166, "tastiness_constraint")
m.addConstr(2*x0 + 14*x2 >= 32, "c1")
m.addConstr(14*x2 + 6*x3 >= 23, "c2")
m.addConstr(14*x1 + 2*x4 >= 30, "c3")
m.addConstr(14*x1 + 6*x3 >= 32, "c4")
m.addConstr(14*x1 + 14*x2 >= 32, "c5")
m.addConstr(2*x0 + 14*x1 >= 21, "c6")
m.addConstr(14*x1 + 6*x3 + 2*x4 >= 26, "c7")
m.addConstr(2*x0 + 14*x1 + 6*x3 >= 26, "c8")
m.addConstr(14*x1 + 6*x3 + 2*x4 >= 24, "c9")
m.addConstr(2*x0 + 14*x1 + 6*x3 >= 24, "c10")
m.addConstr(4*x0 + 10*x2 + 11*x3 <= 159, "c11")
m.addConstr(4*x0 + 5*x1 + 11*x3 <= 182, "c12")
m.addConstr(4*x0 + 5*x1 + 10*x2 <= 59, "c13")
m.addConstr(4*x0 + 5*x1 + 10*x2 + 11*x3 + 9*x4 <= 59, "c14")
m.addConstr(14*x1 + 6*x3 <= 79, "c15")
m.addConstr(2*x0 + 2*x4 <= 63, "c16")
m.addConstr(14*x2 + 6*x3 <= 33, "c17")
m.addConstr(14*x1 + 2*x4 <= 122, "c18")
m.addConstr(6*x3 + 2*x4 <= 36, "c19")
m.addConstr(2*x0 + 6*x3 <= 163, "c20")
m.addConstr(2*x0 + 14*x1 + 14*x2 + 6*x3 + 2*x4 <= 163, "c21")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", m.status)

