
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("optimize_work_hours")

    # Create variables
    dale = model.addVar(vtype=gp.GRB.INTEGER, name="dale")
    peggy = model.addVar(vtype=gp.GRB.INTEGER, name="peggy")
    george = model.addVar(vtype=gp.GRB.INTEGER, name="george")
    bobby = model.addVar(vtype=gp.GRB.INTEGER, name="bobby")

    # Set objective function
    model.setObjective(4.89 * dale + 2.71 * peggy + 2.84 * george + 2.81 * bobby, gp.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(2.77 * george + 1.19 * bobby >= 36)
    model.addConstr(6.87 * peggy + 1.19 * bobby >= 40)
    model.addConstr(7.93 * george + 12.05 * bobby >= 14)
    model.addConstr(3.76 * dale + 9.8 * peggy >= 19)
    model.addConstr(2.77 * george + 1.19 * bobby <= 109)
    model.addConstr(6.87 * peggy + 2.77 * george <= 70)
    model.addConstr(6.87 * peggy + 2.77 * george + 1.19 * bobby <= 157)
    model.addConstr(1.32 * dale + 2.77 * george + 1.19 * bobby <= 72)
    model.addConstr(1.32 * dale + 6.87 * peggy + 2.77 * george + 1.19 * bobby <= 72)
    model.addConstr(7.93 * george + 12.05 * bobby <= 134)
    model.addConstr(3.76 * dale + 9.8 * peggy <= 70)
    model.addConstr(3.76 * dale + 12.05 * bobby <= 113)
    model.addConstr(9.8 * peggy + 12.05 * bobby <= 138)
    model.addConstr(3.76 * dale + 9.8 * peggy + 12.05 * bobby <= 142)
    model.addConstr(9.8 * peggy + 7.93 * george + 12.05 * bobby <= 84)
    model.addConstr(3.76 * dale + 9.8 * peggy + 7.93 * george <= 57)
    model.addConstr(3.76 * dale + 9.8 * peggy + 7.93 * george + 12.05 * bobby <= 57)


    # Optimize model
    model.optimize()

    if model.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        for v in model.getVars():
            print('%s %g' % (v.varName, v.x))
    elif model.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization ended with status {model.status}")


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
