
from gurobipy import Model, GRB

# Create a new model
model = Model("Work Optimization")

# Create variables
john = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="John")
jean = model.addVar(lb=0, vtype=GRB.INTEGER, name="Jean")
mary = model.addVar(lb=0, vtype=GRB.INTEGER, name="Mary")
peggy = model.addVar(lb=0, vtype=GRB.INTEGER, name="Peggy")
bill = model.addVar(lb=0, vtype=GRB.INTEGER, name="Bill")
ringo = model.addVar(lb=0, vtype=GRB.INTEGER, name="Ringo")


# Set objective function
model.setObjective(6.84 * john + 9.37 * jean + 6.19 * mary + 5.75 * peggy + 9.17 * bill + 6.6 * ringo, GRB.MAXIMIZE)

# Add constraints
model.addConstr(2 * peggy + 3 * ringo >= 17)
model.addConstr(6 * john + 3 * ringo >= 26)
model.addConstr(6 * john + 4 * bill >= 38)
model.addConstr(3 * jean + 3 * ringo >= 36)
model.addConstr(6 * john + 3 * jean >= 28)
model.addConstr(2 * peggy + 4 * bill >= 32)
model.addConstr(3 * jean + 5 * mary + 2 * peggy >= 32)
model.addConstr(6 * john + 4 * bill + 3 * ringo >= 32)
model.addConstr(3 * jean + 5 * mary + 2 * peggy >= 38)
model.addConstr(6 * john + 4 * bill + 3 * ringo >= 38)
model.addConstr(3 * john + 9 * jean >= 13)
model.addConstr(3 * john + 1 * mary >= 22)
model.addConstr(1 * mary + 4 * bill >= 27)
model.addConstr(4 * bill + 11 * ringo >= 29)
model.addConstr(9 * peggy + 11 * ringo >= 10)
model.addConstr(9 * jean + 11 * ringo >= 13)
model.addConstr(9 * jean + 9 * peggy + 4 * bill >= 23)
model.addConstr(1 * mary + 4 * bill + 11 * ringo >= 23)
model.addConstr(9 * jean + 1 * mary + 11 * ringo >= 23)
model.addConstr(1 * mary + 9 * peggy + 11 * ringo >= 23)
model.addConstr(3 * john + 4 * bill + 11 * ringo >= 23)

# ... (rest of the constraints from the JSON)


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    for v in model.getVars():
        print('%s %g' % (v.varName, v.x))
elif model.status == GRB.INFEASIBLE:
    print("Model is infeasible")
else:
    print("Optimization ended with status %d" % model.status)

