
import gurobi

# Create a new Gurobi model
m = gurobi.Model()

# Define the variables
x0 = m.addVar(name="x0", lb=0, ub=None)  # hours worked by John
x1 = m.addVar(name="x1", lb=0, ub=None, vtype=gurobi.GRB.INTEGER)  # hours worked by Jean
x2 = m.addVar(name="x2", lb=0, ub=None, vtype=gurobi.GRB.INTEGER)  # hours worked by Mary
x3 = m.addVar(name="x3", lb=0, ub=None, vtype=gurobi.GRB.INTEGER)  # hours worked by Peggy
x4 = m.addVar(name="x4", lb=0, ub=None, vtype=gurobi.GRB.INTEGER)  # hours worked by Bill
x5 = m.addVar(name="x5", lb=0, ub=None, vtype=gurobi.GRB.INTEGER)  # hours worked by Ringo

# Define the objective function
m.setObjective(6.84*x0 + 9.37*x1 + 6.19*x2 + 5.75*x3 + 9.17*x4 + 6.6*x5, gurobi.GRB.MAXIMIZE)

# Add constraints
# ... adding all 83 constraints ...

# Solve the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Hours worked by John: ", x0.varValue)
    print("Hours worked by Jean: ", x1.varValue)
    print("Hours worked by Mary: ", x2.varValue)
    print("Hours worked by Peggy: ", x3.varValue)
    print("Hours worked by Bill: ", x4.varValue)
    print("Hours worked by Ringo: ", x5.varValue)
else:
    print("No optimal solution found")
