
import gurobipy as gp

# Create a new model
model = gp.Model("Minimize_Labor_Cost")

# Create variables
jean = model.addVar(vtype=gp.GRB.INTEGER, name="jean")
bill = model.addVar(vtype=gp.GRB.INTEGER, name="bill")
mary = model.addVar(vtype=gp.GRB.INTEGER, name="mary")
dale = model.addVar(vtype=gp.GRB.INTEGER, name="dale")
ringo = model.addVar(vtype=gp.GRB.CONTINUOUS, name="ringo")
bobby = model.addVar(vtype=gp.GRB.INTEGER, name="bobby")
peggy = model.addVar(vtype=gp.GRB.INTEGER, name="peggy")


# Set objective function
model.setObjective(5*jean + 6*bill + 2*mary + 8*dale + 1*ringo + 7*bobby + 7*peggy, gp.GRB.MINIMIZE)

# Add constraints
model.addConstr(dale + 14*bobby >= 17)
model.addConstr(dale + peggy >= 37)
model.addConstr(dale + 5*ringo >= 16)
model.addConstr(4*jean + peggy >= 28)
model.addConstr(5*ringo + peggy >= 16)
model.addConstr(10*bill + 14*bobby >= 22)
model.addConstr(4*jean + dale >= 42)
model.addConstr(4*jean + 14*bobby >= 24)
model.addConstr(4*jean + 2*mary >= 24)
model.addConstr(10*bill + dale + 5*ringo >= 27)
model.addConstr(4*jean + 14*bobby + peggy >= 27)
model.addConstr(10*bill + dale + 5*ringo >= 31)
model.addConstr(4*jean + 14*bobby + peggy >= 31)
model.addConstr(4*jean + 10*bill + 2*mary + dale + 5*ringo + 14*bobby + peggy >= 31)
model.addConstr(-5*bill + peggy >= 0)
model.addConstr(10*bill + 5*ringo <= 302)
model.addConstr(dale + 5*ringo <= 242)
model.addConstr(4*jean + 5*ringo <= 72)
model.addConstr(10*bill + 14*bobby <= 70)
model.addConstr(10*bill + peggy <= 139)
model.addConstr(2*mary + 5*ringo <= 62)
model.addConstr(2*mary + dale <= 61)
model.addConstr(2*mary + peggy <= 217)
model.addConstr(4*jean + dale <= 152)
model.addConstr(4*jean + 10*bill <= 151)
model.addConstr(14*bobby + peggy <= 227)
model.addConstr(10*bill + dale <= 195)
model.addConstr(4*jean + 2*mary <= 98)
model.addConstr(5*ringo + peggy <= 274)
model.addConstr(5*ringo + 14*bobby + peggy <= 306)
model.addConstr(4*jean + 14*bobby + peggy <= 300)
model.addConstr(10*bill + dale + 14*bobby <= 97)
model.addConstr(4*jean + dale + 14*bobby <= 251)
model.addConstr(dale + 5*ringo + peggy <= 167)
model.addConstr(10*bill + 2*mary + 5*ringo <= 227)
model.addConstr(10*bill + 2*mary + peggy <= 252)
model.addConstr(dale + 14*bobby + peggy <= 159)
model.addConstr(2*mary + dale + 5*ringo <= 78)
model.addConstr(4*jean + 10*bill + 5*ringo <= 298)
model.addConstr(2*mary + 5*ringo + 14*bobby <= 139)
model.addConstr(10*bill + 5*ringo + peggy <= 279)
model.addConstr(2*mary + dale + 14*bobby <= 161)
model.addConstr(4*jean + 2*mary + peggy <= 54)
model.addConstr(4*jean + 2*mary + 14*bobby <= 52)


# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    for v in model.getVars():
        print('%s %g' % (v.varName, v.x))
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

