
from gurobipy import *

# Create a new model
m = Model("optimization_problem")

# Create variables
john = m.addVar(vtype=GRB.INTEGER, name="john")
dale = m.addVar(vtype=GRB.INTEGER, name="dale")
mary = m.addVar(vtype=GRB.INTEGER, name="mary")
paul = m.addVar(vtype=GRB.INTEGER, name="paul")
ringo = m.addVar(vtype=GRB.INTEGER, name="ringo")


# Set objective
m.setObjective(6*john**2 + john*paul + 5*john*ringo + 9*paul*ringo + paul, GRB.MAXIMIZE)

# Add constraints
m.addConstr(15*dale + paul + 9*ringo >= 52)
m.addConstr(15*dale**2 + 26*mary**2 + 9*ringo**2 >= 52)
m.addConstr(28*john + 26*mary + paul >= 52)
m.addConstr(28*john + 15*dale + 26*mary >= 52)
m.addConstr(28*john + paul + 9*ringo >= 52)
m.addConstr(26*mary**2 + paul**2 + 9*ringo**2 >= 52)
m.addConstr(15*dale + 26*mary + paul >= 52)
m.addConstr(28*john + 15*dale + 9*ringo >= 52)
m.addConstr(15*dale + paul + 9*ringo >= 44)
m.addConstr(15*dale + 26*mary + 9*ringo >= 44)
m.addConstr(28*john**2 + 26*mary**2 + paul**2 >= 44)
m.addConstr(28*john + 15*dale + 26*mary >= 44)
m.addConstr(28*john + paul + 9*ringo >= 44)
m.addConstr(26*mary + paul + 9*ringo >= 44)
m.addConstr(15*dale + 26*mary + paul >= 44)
m.addConstr(28*john + 15*dale + 9*ringo >= 44)
m.addConstr(15*dale + paul + 9*ringo >= 36)
m.addConstr(15*dale + 26*mary + 9*ringo >= 36)
m.addConstr(28*john**2 + 26*mary**2 + paul**2 >= 36)
m.addConstr(28*john + 15*dale + 26*mary >= 36)
m.addConstr(28*john + paul + 9*ringo >= 36)
m.addConstr(26*mary + paul + 9*ringo >= 36)
m.addConstr(15*dale**2 + 26*mary**2 + paul**2 >= 36)
m.addConstr(28*john + 15*dale + 9*ringo >= 36)
m.addConstr(15*dale + paul + 9*ringo >= 68)
m.addConstr(15*dale + 26*mary + 9*ringo >= 68)
m.addConstr(28*john + 26*mary + paul >= 68)
m.addConstr(28*john**2 + 15*dale**2 + 26*mary**2 >= 68)
m.addConstr(28*john + paul + 9*ringo >= 68)
m.addConstr(26*mary + paul + 9*ringo >= 68)
m.addConstr(15*dale + 26*mary + paul >= 68)
m.addConstr(28*john + 15*dale + 9*ringo >= 68)
m.addConstr(15*dale + paul + 9*ringo >= 51)
m.addConstr(15*dale**2 + 26*mary**2 + 9*ringo**2 >= 51)
m.addConstr(28*john + 26*mary + paul >= 51)
m.addConstr(28*john + 15*dale + 26*mary >= 51)
m.addConstr(28*john + paul + 9*ringo >= 51)
m.addConstr(26*mary**2 + paul**2 + 9*ringo**2 >= 51)
m.addConstr(15*dale + 26*mary + paul >= 51)
m.addConstr(28*john + 15*dale + 9*ringo >= 51)
m.addConstr(15*dale**2 + paul**2 + 9*ringo**2 >= 41)
m.addConstr(15*dale**2 + 26*mary**2 + 9*ringo**2 >= 41)
m.addConstr(28*john + 26*mary + paul >= 41)
m.addConstr(28*john + 15*dale + 26*mary >= 41)
m.addConstr(28*john + paul + 9*ringo >= 41)
m.addConstr(26*mary + paul + 9*ringo >= 41)
m.addConstr(15*dale + 26*mary + paul >= 41)
m.addConstr(28*john + 15*dale + 9*ringo >= 41)
m.addConstr(15*dale + paul + 9*ringo >= 48)
m.addConstr(15*dale**2 + 26*mary**2 + 9*ringo**2 >= 48)
m.addConstr(28*john**2 + 26*mary**2 + paul**2 >= 48)
m.addConstr(28*john + 15*dale + 26*mary >= 48)
m.addConstr(28*john + paul + 9*ringo >= 48)
m.addConstr(26*mary + paul + 9*ringo >= 48)
m.addConstr(15*dale**2 + 26*mary**2 + paul**2 >= 48)
m.addConstr(28*john + 15*dale + 9*ringo >= 48)
m.addConstr(15*dale**2 + paul**2 + 9*ringo**2 >= 50)
m.addConstr(15*dale + 26*mary + 9*ringo >= 50)
m.addConstr(28*john + 26*mary + paul >= 50)
m.addConstr(28*john**2 + 15*dale**2 + 26*mary**2 >= 50)
m.addConstr(28*john + paul + 9*ringo >= 50)
m.addConstr(26*mary**2 + paul**2 + 9*ringo**2 >= 50)
m.addConstr(15*dale + 26*mary + paul >= 50)
m.addConstr(28*john + 15*dale + 9*ringo >= 50)
m.addConstr(-4*john + 4*ringo >= 0)
m.addConstr(28*john + 26*mary <= 210)
m.addConstr(28*john + paul <= 296)
m.addConstr(28*john + 15*dale <= 229)
m.addConstr(15*dale + 26*mary <= 79)
m.addConstr(26*mary + 9*ringo <= 331)
m.addConstr(28*john**2 + 9*ringo**2 <= 134)
m.addConstr(15*dale + paul <= 339)
m.addConstr(26*mary + paul <= 298)
m.addConstr(26*mary**2 + paul**2 + 9*ringo**2 <= 202)
m.addConstr(28*john + 15*dale + 26*mary + paul + 9*ringo <= 202)



# Optimize model
m.optimize()

if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == GRB.INFEASIBLE:
    print("The problem is infeasible.")
else:
    print("Optimization ended with status:", m.status)

