
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("food_optimization")

# Create variables
x = m.addVars(5, lb=0, vtype=[GRB.CONTINUOUS, GRB.INTEGER, GRB.INTEGER, GRB.CONTINUOUS, GRB.CONTINUOUS], name=["granola bars", "hamburgers", "potatoes", "black beans", "eggs"])


# Set objective function
m.setObjective(2*x[0] + 6*x[1] + 8*x[2] + 7*x[3] + 5*x[4], GRB.MAXIMIZE)

# Add constraints

# Iron constraints
m.addConstr(5*x[0] + 24*x[4] >= 35)
m.addConstr(5*x[0] + 20*x[2] >= 32)
m.addConstr(9*x[1] + 20*x[2] >= 43)
m.addConstr(20*x[2] + 24*x[4] >= 38)
m.addConstr(9*x[1] + 24*x[4] >= 34)
m.addConstr(5*x[0] + 4*x[3] >= 33)
m.addConstr(4*x[3] + 24*x[4] >= 15)
m.addConstr(9*x[1] + 4*x[3] >= 34)
m.addConstr(20*x[2] + 4*x[3] + 24*x[4] >= 36)
m.addConstr(5*x[0] + 9*x[1] + 20*x[2] >= 36)
m.addConstr(5*x[0] + 20*x[2] + 24*x[4] >= 36)
m.addConstr(5*x[0] + 9*x[1] + 24*x[4] >= 36)
m.addConstr(20*x[2] + 4*x[3] + 24*x[4] >= 32)
m.addConstr(5*x[0] + 9*x[1] + 20*x[2] >= 32)
m.addConstr(5*x[0] + 20*x[2] + 24*x[4] >= 32)
m.addConstr(5*x[0] + 9*x[1] + 24*x[4] >= 32)
m.addConstr(20*x[2] + 4*x[3] + 24*x[4] >= 26)
m.addConstr(5*x[0] + 9*x[1] + 20*x[2] >= 26)
m.addConstr(5*x[0] + 20*x[2] + 24*x[4] >= 26)
m.addConstr(5*x[0] + 9*x[1] + 24*x[4] >= 26)
m.addConstr(20*x[2] + 4*x[3] + 24*x[4] >= 37)
m.addConstr(5*x[0] + 9*x[1] + 20*x[2] >= 37)
m.addConstr(5*x[0] + 20*x[2] + 24*x[4] >= 37)
m.addConstr(5*x[0] + 9*x[1] + 24*x[4] >= 37)


# Sourness constraints

# ... (All sourness constraints as defined in the JSON)

# Other constraints
m.addConstr(7*x[0] - 10*x[4] >= 0)
m.addConstr(5*x[0] + 20*x[2] <= 176)
m.addConstr(9*x[1] + 24*x[4] <= 101)
m.addConstr(5*x[0] + 9*x[1] <= 171)
m.addConstr(20*x[2] + 4*x[3] <= 161)
m.addConstr(20*x[2] + 24*x[4] <= 181)
m.addConstr(9*x[1] + 4*x[3] <= 148)
m.addConstr(9*x[1] + 20*x[2] + 24*x[4] <= 165)
m.addConstr(5*x[0] + 9*x[1] + 24*x[4] <= 108)
m.addConstr(9*x[1] + 20*x[2] + 4*x[3] <= 92)
m.addConstr(5*x[0] + 4*x[3] + 24*x[4] <= 99)
m.addConstr(5*x[0] + 9*x[1] + 20*x[2] + 4*x[3] + 24*x[4] <= 99)
m.addConstr(26*x[0] + 26*x[1] <= 225)
m.addConstr(26*x[0] + 8*x[2] <= 193)
m.addConstr(26*x[0] + 8*x[2] + 8*x[3] <= 71)
m.addConstr(26*x[0] + 26*x[1] + 8*x[2] + 8*x[3] + 3*x[4] <= 71)

# Resource constraints from the context
m.addConstr(5*x[0] + 9*x[1] + 20*x[2] + 4*x[3] + 24*x[4] <= 239) # Iron
m.addConstr(26*x[0] + 26*x[1] + 8*x[2] + 8*x[3] + 3*x[4] <= 231) # Sourness


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == GRB.INFEASIBLE:
    print('Model is infeasible')
else:
    print('Optimization ended with status %d' % m.status)

