
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    kale_salads = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="kale_salads")
    potatoes = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="potatoes")
    blueberry_pies = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="blueberry_pies")

    # Set objective function
    m.setObjective(8.33 * kale_salads + 8.71 * potatoes + 9.53 * blueberry_pies, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(1 * kale_salads + 12 * potatoes >= 22, "c0")
    m.addConstr(12 * potatoes + 6 * blueberry_pies >= 17, "c1")
    m.addConstr(3 * kale_salads + 3 * blueberry_pies >= 24, "c2")
    m.addConstr(10 * potatoes + 13 * blueberry_pies >= 57, "c3")
    m.addConstr(2 * kale_salads + 13 * blueberry_pies >= 56, "c4")
    m.addConstr(10 * kale_salads + 14 * blueberry_pies >= 59, "c5")
    m.addConstr(8 * potatoes + 14 * blueberry_pies >= 41, "c6")
    m.addConstr(-3 * kale_salads + 7 * blueberry_pies >= 0, "c7")
    m.addConstr(12 * potatoes + 6 * blueberry_pies <= 79, "c8")
    m.addConstr(1 * kale_salads + 12 * potatoes + 6 * blueberry_pies <= 31, "c9")
    m.addConstr(3 * kale_salads + 3 * blueberry_pies <= 120, "c10")
    m.addConstr(3 * kale_salads + 6 * potatoes <= 130, "c11")
    m.addConstr(3 * kale_salads + 6 * potatoes + 3 * blueberry_pies <= 130, "c12")
    m.addConstr(2 * kale_salads + 13 * blueberry_pies <= 92, "c13")
    m.addConstr(2 * kale_salads + 10 * potatoes <= 146, "c14")
    m.addConstr(10 * potatoes + 13 * blueberry_pies <= 69, "c15")
    m.addConstr(10 * kale_salads + 8 * potatoes <= 117, "c16")
    m.addConstr(10 * kale_salads + 8 * potatoes + 14 * blueberry_pies <= 117, "c17")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
