
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(name="kale_salads", lb=0)
    x1 = model.addVar(name="potatoes", lb=0)
    x2 = model.addVar(name="blueberry_pies", lb=0)

    # Define the objective function
    model.setObjective(8.33 * x0 + 8.71 * x1 + 9.53 * x2, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(x0 + 12 * x1 + 6 * x2 <= 89)
    model.addConstr(3 * x0 + 6 * x1 + 3 * x2 <= 156)
    model.addConstr(2 * x0 + 10 * x1 + 13 * x2 <= 209)
    model.addConstr(10 * x0 + 8 * x1 + 14 * x2 <= 197)
    model.addConstr(x0 + 12 * x1 >= 22)
    model.addConstr(12 * x1 + 6 * x2 >= 17)
    model.addConstr(3 * x0 + 3 * x2 >= 24)
    model.addConstr(10 * x1 + 13 * x2 >= 57)
    model.addConstr(2 * x0 + 13 * x2 >= 56)
    model.addConstr(10 * x0 + 14 * x2 >= 59)
    model.addConstr(8 * x1 + 14 * x2 >= 41)
    model.addConstr(-3 * x0 + 7 * x2 >= 0)
    model.addConstr(12 * x1 + 6 * x2 <= 79)
    model.addConstr(x0 + 12 * x1 + 6 * x2 <= 31)
    model.addConstr(3 * x0 + 6 * x1 + 3 * x2 <= 120)
    model.addConstr(3 * x0 + 6 * x1 <= 130)
    model.addConstr(3 * x0 + 6 * x1 + 3 * x2 <= 130)
    model.addConstr(2 * x0 + 13 * x2 <= 92)
    model.addConstr(2 * x0 + 10 * x1 <= 146)
    model.addConstr(10 * x1 + 13 * x2 <= 69)
    model.addConstr(2 * x0 + 10 * x1 + 13 * x2 <= 69)
    model.addConstr(10 * x0 + 8 * x1 <= 117)
    model.addConstr(10 * x0 + 8 * x1 + 14 * x2 <= 117)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
        print("Kale Salads: ", x0.varValue)
        print("Potatoes: ", x1.varValue)
        print("Blueberry Pies: ", x2.varValue)
    else:
        print("The model is infeasible")

solve_optimization_problem()
