
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("food_optimization")

    # Create variables
    eggs = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="eggs")
    strawberries = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="strawberries")
    tomatoes = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="tomatoes")
    peanutbutter_sandwiches = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="peanutbutter_sandwiches")

    # Set objective function
    m.setObjective(2.65 * eggs + 6.12 * strawberries + 5.16 * tomatoes + 8.03 * peanutbutter_sandwiches, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(4 * eggs + 3 * strawberries + 12 * tomatoes + 3 * peanutbutter_sandwiches <= 146, "c0")
    m.addConstr(6 * eggs + 11 * strawberries + 14 * tomatoes + 14 * peanutbutter_sandwiches <= 90, "c1")
    m.addConstr(12 * tomatoes + 3 * peanutbutter_sandwiches >= 13, "c2")
    m.addConstr(3 * strawberries + 12 * tomatoes >= 31, "c3")
    m.addConstr(4 * eggs + 3 * peanutbutter_sandwiches >= 35, "c4")
    m.addConstr(6 * eggs + 11 * strawberries + 14 * peanutbutter_sandwiches >= 18, "c5")
    m.addConstr(11 * strawberries + 14 * tomatoes + 14 * peanutbutter_sandwiches >= 18, "c6")
    m.addConstr(6 * eggs + 11 * strawberries + 14 * tomatoes >= 18, "c7")
    m.addConstr(12 * tomatoes + 3 * peanutbutter_sandwiches <= 84, "c8")
    m.addConstr(4 * eggs + 3 * strawberries <= 101, "c9")
    m.addConstr(4 * eggs + 3 * peanutbutter_sandwiches <= 116, "c10")
    m.addConstr(4 * eggs + 12 * tomatoes <= 47, "c11")
    m.addConstr(3 * strawberries + 3 * peanutbutter_sandwiches <= 59, "c12")
    m.addConstr(3 * strawberries + 12 * tomatoes + 3 * peanutbutter_sandwiches <= 128, "c13")
    m.addConstr(4 * eggs + 3 * strawberries + 3 * peanutbutter_sandwiches <= 122, "c14")
    m.addConstr(4 * eggs + 12 * tomatoes + 3 * peanutbutter_sandwiches <= 120, "c15")
    m.addConstr(4 * eggs + 3 * strawberries + 12 * tomatoes + 3 * peanutbutter_sandwiches <= 120, "c16")
    m.addConstr(6 * eggs + 14 * peanutbutter_sandwiches <= 69, "c17")
    m.addConstr(11 * strawberries + 14 * tomatoes <= 36, "c18")
    m.addConstr(6 * eggs + 11 * strawberries <= 38, "c19")
    m.addConstr(6 * eggs + 11 * strawberries + 14 * tomatoes + 14 * peanutbutter_sandwiches <= 38, "c20")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
