
import gurobi

def solve_optimization_problem():
    model = gurobi.Model()

    # Define variables
    eggs = model.addVar(name="eggs", lb=0)
    strawberries = model.addVar(name="strawberries", lb=0)
    tomatoes = model.addVar(name="tomatoes", lb=0)
    peanutbutter_sandwiches = model.addVar(name="peanutbutter_sandwiches", lb=0)

    # Objective function
    model.setObjective(2.65 * eggs + 6.12 * strawberries + 5.16 * tomatoes + 8.03 * peanutbutter_sandwiches, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(4 * eggs + 3 * strawberries + 12 * tomatoes + 3 * peanutbutter_sandwiches <= 146)
    model.addConstr(6 * eggs + 11 * strawberries + 14 * tomatoes + 14 * peanutbutter_sandwiches <= 90)
    model.addConstr(12 * tomatoes + 3 * peanutbutter_sandwiches >= 13)
    model.addConstr(3 * strawberries + 12 * tomatoes >= 31)
    model.addConstr(4 * eggs + 3 * peanutbutter_sandwiches >= 35)
    model.addConstr(6 * eggs + 11 * strawberries + 14 * peanutbutter_sandwiches >= 18)
    model.addConstr(11 * strawberries + 14 * tomatoes + 14 * peanutbutter_sandwiches >= 18)
    model.addConstr(6 * eggs + 11 * strawberries + 14 * tomatoes >= 18)
    model.addConstr(6 * eggs + 11 * strawberries + 14 * peanutbutter_sandwiches >= 13)
    model.addConstr(11 * strawberries + 14 * tomatoes + 14 * peanutbutter_sandwiches >= 13)
    model.addConstr(6 * eggs + 11 * strawberries + 14 * tomatoes >= 13)
    model.addConstr(12 * tomatoes + 3 * peanutbutter_sandwiches <= 84)
    model.addConstr(4 * eggs + 3 * strawberries <= 101)
    model.addConstr(4 * eggs + 3 * peanutbutter_sandwiches <= 116)
    model.addConstr(4 * eggs + 12 * tomatoes <= 47)
    model.addConstr(3 * strawberries + 3 * peanutbutter_sandwiches <= 59)
    model.addConstr(3 * strawberries + 12 * tomatoes + 3 * peanutbutter_sandwiches <= 128)
    model.addConstr(4 * eggs + 3 * strawberries + 3 * peanutbutter_sandwiches <= 122)
    model.addConstr(4 * eggs + 12 * tomatoes + 3 * peanutbutter_sandwiches <= 120)
    model.addConstr(4 * eggs + 3 * strawberries + 12 * tomatoes + 3 * peanutbutter_sandwiches <= 120)
    model.addConstr(6 * eggs + 14 * peanutbutter_sandwiches <= 69)
    model.addConstr(11 * strawberries + 14 * tomatoes <= 36)
    model.addConstr(6 * eggs + 11 * strawberries <= 38)
    model.addConstr(6 * eggs + 11 * strawberries + 14 * tomatoes + 14 * peanutbutter_sandwiches <= 38)

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
        print("Eggs: ", eggs.varValue)
        print("Strawberries: ", strawberries.varValue)
        print("Tomatoes: ", tomatoes.varValue)
        print("Peanutbutter sandwiches: ", peanutbutter_sandwiches.varValue)
    else:
        print("No optimal solution found")

solve_optimization_problem()
