
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    hank = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="hank")
    paul = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="paul")
    dale = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="dale")
    mary = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="mary")


    # Set objective function
    m.setObjective(7 * hank + 4 * paul + 8 * dale + 5 * mary, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(18 * hank + 8 * dale + 2 * mary >= 105)
    m.addConstr(18 * hank + 25 * paul + 2 * mary >= 105)
    m.addConstr(18 * hank + 25 * paul + 8 * dale >= 105)
    m.addConstr(18 * hank + 8 * dale + 2 * mary >= 54)
    m.addConstr(18 * hank + 25 * paul + 2 * mary >= 54)
    m.addConstr(18 * hank + 25 * paul + 8 * dale >= 54)
    m.addConstr(18 * hank + 8 * dale + 2 * mary >= 95)
    m.addConstr(18 * hank + 25 * paul + 2 * mary >= 95)
    m.addConstr(18 * hank + 25 * paul + 8 * dale >= 95)
    m.addConstr(17 * hank + 4 * dale >= 72)
    m.addConstr(17 * hank + 7 * mary >= 82)
    m.addConstr(26 * paul + 4 * dale >= 92)
    m.addConstr(17 * hank + 26 * paul >= 48)
    m.addConstr(17 * hank + 26 * paul + 7 * mary >= 82)
    # ... (rest of the constraints)

    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('hank:', hank.x)
        print('paul:', paul.x)
        print('dale:', dale.x)
        print('mary:', mary.x)
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GrorbiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
