
import gurobi

def solve_optimization_problem():
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(name="x0", lb=0)  # hours worked by Hank
    x1 = model.addVar(name="x1", lb=0)  # hours worked by Paul
    x2 = model.addVar(name="x2", lb=0)  # hours worked by Dale
    x3 = model.addVar(name="x3", lb=0)  # hours worked by Mary

    # Objective function
    model.setObjective(7 * x0 + 4 * x1 + 8 * x2 + 5 * x3, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(18 * x0 + 8 * x2 + 2 * x3 >= 105)
    model.addConstr(18 * x0 + 25 * x1 + 2 * x3 >= 105)
    model.addConstr(18 * x0 + 25 * x1 + 8 * x2 >= 105)
    model.addConstr(18 * x0 + 8 * x2 + 2 * x3 >= 54)
    model.addConstr(18 * x0 + 25 * x1 + 2 * x3 >= 54)
    model.addConstr(18 * x0 + 25 * x1 + 8 * x2 >= 54)
    model.addConstr(18 * x0 + 8 * x2 + 2 * x3 >= 95)
    model.addConstr(18 * x0 + 25 * x1 + 2 * x3 >= 95)
    model.addConstr(18 * x0 + 25 * x1 + 8 * x2 >= 95)
    model.addConstr(17 * x0 + 4 * x2 >= 72)
    model.addConstr(17 * x0 + 7 * x3 >= 82)
    model.addConstr(26 * x1 + 4 * x2 >= 92)
    model.addConstr(17 * x0 + 26 * x1 >= 48)
    model.addConstr(17 * x0 + 26 * x1 + 7 * x3 >= 82)
    model.addConstr(10 * x0 + 9 * x1 + 21 * x2 >= 46)
    model.addConstr(10 * x0 + 21 * x2 + 10 * x3 >= 46)
    model.addConstr(10 * x0 + 9 * x1 + 10 * x3 >= 46)
    model.addConstr(10 * x0 + 9 * x1 + 21 * x2 >= 74)
    model.addConstr(10 * x0 + 21 * x2 + 10 * x3 >= 74)
    model.addConstr(10 * x0 + 9 * x1 + 10 * x3 >= 74)
    model.addConstr(10 * x0 + 9 * x1 + 21 * x2 >= 44)
    model.addConstr(10 * x0 + 21 * x2 + 10 * x3 >= 44)
    model.addConstr(10 * x0 + 9 * x1 + 10 * x3 >= 44)
    model.addConstr(22 * x0 + 21 * x1 >= 49)
    model.addConstr(21 * x1 + 3 * x2 >= 47)
    model.addConstr(22 * x0 + 21 * x1 + 3 * x2 >= 46)
    model.addConstr(25 * x1 + 8 * x2 <= 183)
    model.addConstr(18 * x0 + 8 * x2 <= 227)
    model.addConstr(18 * x0 + 2 * x3 <= 304)
    model.addConstr(8 * x2 + 2 * x3 <= 357)
    model.addConstr(25 * x1 + 2 * x3 <= 410)
    model.addConstr(18 * x0 + 25 * x1 + 8 * x2 + 2 * x3 <= 410)
    model.addConstr(17 * x0 + 26 * x1 <= 200)
    model.addConstr(26 * x1 + 7 * x3 <= 267)
    model.addConstr(26 * x1 + 4 * x2 <= 201)
    model.addConstr(26 * x1 + 4 * x2 + 7 * x3 <= 129)
    model.addConstr(17 * x0 + 26 * x1 + 4 * x2 + 7 * x3 <= 129)
    model.addConstr(10 * x0 + 9 * x1 <= 148)
    model.addConstr(10 * x0 + 10 * x3 <= 236)
    model.addConstr(21 * x2 + 10 * x3 <= 150)
    model.addConstr(10 * x0 + 21 * x2 <= 115)
    model.addConstr(9 * x1 + 21 * x2 <= 120)
    model.addConstr(10 * x0 + 9 * x1 + 21 * x2 + 10 * x3 <= 120)
    model.addConstr(21 * x1 + 3 * x2 <= 118)
    model.addConstr(21 * x1 + 2 * x3 <= 175)
    model.addConstr(3 * x2 + 2 * x3 <= 104)
    model.addConstr(22 * x0 + 2 * x3 <= 216)
    model.addConstr(22 * x0 + 21 * x1 + 3 * x2 + 2 * x3 <= 216)
    model.addConstr(9 * x0 + 18 * x2 <= 252)
    model.addConstr(12 * x1 + 24 * x3 <= 178)
    model.addConstr(12 * x1 + 18 * x2 <= 140)
    model.addConstr(18 * x2 + 24 * x3 <= 184)
    model.addConstr(9 * x0 + 12 * x1 + 24 * x3 <= 267)
    model.addConstr(12 * x1 + 18 * x2 + 24 * x3 <= 184)
    model.addConstr(9 * x0 + 18 * x2 + 24 * x3 <= 261)
    model.addConstr(9 * x0 + 12 * x1 + 18 * x2 + 24 * x3 <= 261)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objval)
        print("Hours worked by Hank: ", x0.varValue)
        print("Hours worked by Paul: ", x1.varValue)
        print("Hours worked by Dale: ", x2.varValue)
        print("Hours worked by Mary: ", x3.varValue)
    else:
        print("No optimal solution found")

solve_optimization_problem()
