
from gurobipy import Model, GRB, quicksum

# Create a new model
m = Model("optimization_problem")

# Create variables
knishes = m.addVar(vtype=GRB.INTEGER, name="knishes")
protein_bars = m.addVar(vtype=GRB.CONTINUOUS, name="protein_bars")

# Set objective function
m.setObjective(1.71*knishes**2 + 1.41*knishes*protein_bars + 6.44*protein_bars**2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(5*knishes + 5*protein_bars <= 104, "iron_upper_bound")
m.addConstr(5*knishes**2 + 5*protein_bars**2 >= 46, "iron_squared_lower_bound")
m.addConstr(6*knishes - 3*protein_bars >= 0, "linear_constraint")
m.addConstr(5*knishes**2 + 5*protein_bars**2 <= 52, "iron_squared_upper_bound")
m.addConstr(5*knishes + 5*protein_bars <= 52, "iron_intake_upper_bound")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Objective Value:', m.objVal)
    print('knishes:', knishes.x)
    print('protein_bars:', protein_bars.x)
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

