
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x1 = m.addVar(vtype=GRB.INTEGER, name="knishes")
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="protein_bars")

# Set the objective function
m.setObjective(1.71*x1**2 + 1.41*x1*x2 + 6.44*x2**2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(5*x1 + 5*x2 <= 52, name="iron_content")
m.addConstr(x1**2 + x2**2 >= 46/5, name="min_iron_squared")
m.addConstr(x1**2 + x2**2 <= 52/5, name="max_iron_squared")
m.addConstr(6*x1 - 3*x2 >= 0, name="linear_constraint")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Knishes: {x1.x}")
    print(f"Protein Bars: {x2.x}")
    print(f"Objective Function Value: {m.objVal}")
else:
    print("No optimal solution found")
