
import gurobi

# Define the model
model = gurobi.Model()

# Define the variables
x1 = model.addVar(vtype=gurobi.GRB.INTEGER, name="knishes")
x2 = model.addVar(vtype=gurobi.GRB.CONTINUOUS, name="protein_bars")

# Objective function
model.setObjective(1.71*x1**2 + 1.41*x1*x2 + 6.44*x2**2, gurobi.GRB.MAXIMIZE)

# Constraints
model.addConstr(5*x1**2 + 5*x2**2 >= 46, name="iron_from_squares")
model.addConstr(6*x1 - 3*x2 >= 0, name="knishes_vs_protein_bars")
model.addConstr(5*x1**2 + 5*x2**2 <= 52, name="max_iron_from_squares")
model.addConstr(5*x1 + 5*x2 <= 52, name="max_iron")

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Knishes: {x1.varValue}")
    print(f"Protein Bars: {x2.varValue}")
    print(f"Objective: {model.objVal}")
else:
    print("No optimal solution found.")
