
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    tomatoes = m.addVar(lb=0, name="tomatoes")
    corn_cobs = m.addVar(lb=0, name="corn_cobs")


    # Set objective function
    m.setObjective(3.97 * tomatoes + 3.18 * corn_cobs, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(0.53 * tomatoes + 2.22 * corn_cobs >= 7, "healthiness_min")
    m.addConstr(4.2 * tomatoes + 2.22 * corn_cobs >= 19, "fat_min")
    m.addConstr(0.28 * tomatoes + 4.12 * corn_cobs >= 5, "umami_min")
    m.addConstr(-7 * tomatoes + 1 * corn_cobs >= 0, "custom_constraint")
    m.addConstr(0.53 * tomatoes + 2.22 * corn_cobs <= 14, "healthiness_max")
    m.addConstr(4.2 * tomatoes + 2.22 * corn_cobs <= 47, "fat_max")
    m.addConstr(0.28 * tomatoes + 4.12 * corn_cobs <= 7, "umami_max")


    # Optimize model
    m.optimize()

    # Print results
    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('tomatoes:', tomatoes.x)
        print('corn_cobs:', corn_cobs.x)
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
