
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x1 = m.addVar(name="tomatoes", lb=0)
x2 = m.addVar(name="corn_cobs", lb=0)

# Set the objective function
m.setObjective(3.97*x1 + 3.18*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(0.53*x1 + 2.22*x2 >= 7, name="healthiness_rating_min")
m.addConstr(4.2*x1 + 2.22*x2 >= 19, name="fat_min")
m.addConstr(0.28*x1 + 4.12*x2 >= 5, name="umami_index_min")
m.addConstr(-7*x1 + x2 >= 0, name="tomatoes_corn_cobs_constraint")
m.addConstr(0.53*x1 + 2.22*x2 <= 14, name="healthiness_rating_max")
m.addConstr(4.2*x1 + 2.22*x2 <= 47, name="fat_max")
m.addConstr(0.28*x1 + 4.12*x2 <= 7, name="umami_index_max")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Tomatoes: {x1.x}")
    print(f"Corn Cobs: {x2.x}")
    print(f"Objective Function Value: {m.objVal}")
else:
    print("No optimal solution found")
