
import gurobi

# Define the model
model = gurobi.Model()

# Define the variables
x0 = model.addVar(name="tomatoes", lb=0)  # tomatoes
x1 = model.addVar(name="corn_cobs", lb=0)  # corn cobs

# Define the objective function
model.setObjective(3.97 * x0 + 3.18 * x1, gurobi.GRB.MINIMIZE)

# Define the constraints
model.addConstr(0.53 * x0 + 2.22 * x1 >= 7, name="healthiness_rating_min")
model.addConstr(4.2 * x0 + 2.22 * x1 >= 19, name="grams_of_fat_min")
model.addConstr(0.28 * x0 + 4.12 * x1 >= 5, name="umami_index_min")
model.addConstr(-7 * x0 + x1 >= 0, name="tomatoes_corn_cobs_ratio")
model.addConstr(0.53 * x0 + 2.22 * x1 <= 14, name="healthiness_rating_max")
model.addConstr(4.2 * x0 + 2.22 * x1 <= 47, name="grams_of_fat_max")
model.addConstr(0.28 * x0 + 4.12 * x1 <= 7, name="umami_index_max")

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Tomatoes: {x0.varValue}")
    print(f"Corn Cobs: {x1.varValue}")
    print(f"Objective Function: {model.objVal}")
else:
    print("No optimal solution found.")
