
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x = m.addVars(4, lb=0, vtype=gp.GRB.CONTINUOUS, name=["Jean", "Hank", "Bobby", "Ringo"])


    # Set objective function
    m.setObjective(2*x[0] + 2*x[1] + 9*x[2] + 7*x[3], gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(32*x[1] + 17*x[2] >= 205, "c1")
    m.addConstr(23*x[0] + 32*x[1] + 17*x[2] + 12*x[3] >= 205, "c2")
    m.addConstr(10*x[2] + 10*x[3] >= 64, "c3")
    m.addConstr(15*x[1] + 10*x[3] >= 70, "c4")
    m.addConstr(27*x[0] + 10*x[3] >= 67, "c5")
    m.addConstr(27*x[0] + 15*x[1] + 10*x[2] + 10*x[3] >= 67, "c6")
    m.addConstr(-7*x[0] + 4*x[2] >= 0, "c7")
    m.addConstr(8*x[2] - 6*x[3] >= 0, "c8")
    m.addConstr(-10*x[1] + 2*x[2] + 4*x[3] >= 0, "c9")
    m.addConstr(23*x[0] + 32*x[1] + 12*x[3] <= 632, "c10")
    m.addConstr(15*x[1] + 10*x[3] <= 331, "c11")
    m.addConstr(10*x[2] + 10*x[3] <= 170, "c12")
    m.addConstr(27*x[0] + 10*x[3] <= 228, "c13")
    m.addConstr(27*x[0] + 15*x[1] <= 130, "c14")
    m.addConstr(27*x[0] + 10*x[2] <= 118, "c15")
    m.addConstr(27*x[0] + 15*x[1] + 10*x[2] <= 295, "c16")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        for v in m.getVars():
            print(f'{v.varName}: {v.x}')
        print(f'Obj: {m.objVal}')
    elif m.status == gp.GRB.INFEASIBLE:
        print("The problem is infeasible.")
    else:
        print(f"Optimization ended with status {m.status}")


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
