
import gurobi

def optimization_problem():
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(name="x0", lb=0)  # hours worked by Jean
    x1 = model.addVar(name="x1", lb=0)  # hours worked by Hank
    x2 = model.addVar(name="x2", lb=0)  # hours worked by Bobby
    x3 = model.addVar(name="x3", lb=0)  # hours worked by Ringo

    # Objective function
    model.setObjective(2*x0 + 2*x1 + 9*x2 + 7*x3, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(23*x0 <= 878)
    model.addConstr(32*x1 <= 878)
    model.addConstr(17*x2 <= 878)
    model.addConstr(12*x3 <= 878)

    model.addConstr(27*x0 <= 333)
    model.addConstr(15*x1 <= 333)
    model.addConstr(10*x2 <= 333)
    model.addConstr(10*x3 <= 333)

    model.addConstr(32*x1 + 17*x2 >= 205)
    model.addConstr(23*x0 + 32*x1 + 17*x2 + 12*x3 >= 205)
    model.addConstr(10*x2 + 10*x3 >= 64)
    model.addConstr(15*x1 + 10*x3 >= 70)
    model.addConstr(27*x0 + 10*x3 >= 67)
    model.addConstr(27*x0 + 15*x1 + 10*x2 + 10*x3 >= 67)

    model.addConstr(-7*x0 + 4*x2 >= 0)
    model.addConstr(8*x2 - 6*x3 >= 0)
    model.addConstr(-10*x1 + 2*x2 + 4*x3 >= 0)

    model.addConstr(23*x0 + 32*x1 + 12*x3 <= 632)
    model.addConstr(15*x1 + 10*x3 <= 331)
    model.addConstr(10*x2 + 10*x3 <= 170)
    model.addConstr(27*x0 + 10*x3 <= 228)
    model.addConstr(27*x0 + 15*x1 <= 130)
    model.addConstr(27*x0 + 10*x2 <= 118)
    model.addConstr(27*x0 + 15*x1 + 10*x2 <= 295)

    # Solve the model
    model.optimize()

    if model.status == gurobi.GRB.Status.OPTIMAL:
        print("Optimal solution found.")
        print(f"Hours worked by Jean: {x0.varValue}")
        print(f"Hours worked by Hank: {x1.varValue}")
        print(f"Hours worked by Bobby: {x2.varValue}")
        print(f"Hours worked by Ringo: {x3.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

optimization_problem()
