
import gurobipy as gp

# Create a new model
m = gp.Model("calcium_optimization")

# Create variables
milkshakes = m.addVar(vtype=gp.GRB.INTEGER, name="milkshakes")
sashimi = m.addVar(vtype=gp.GRB.INTEGER, name="sashimi")


# Set objective function
m.setObjective(7 * milkshakes + 1 * sashimi, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(2 * milkshakes + 12 * sashimi >= 31, "calcium_minimum")
m.addConstr(-6 * milkshakes + 7 * sashimi >= 0, "milkshake_sashimi_ratio")
m.addConstr(2 * milkshakes + 12 * sashimi <= 52, "calcium_maximum1")
m.addConstr(2 * milkshakes + 12 * sashimi <= 52, "calcium_maximum2")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal objective value: {m.objVal}")
    print(f"Number of milkshakes: {milkshakes.x}")
    print(f"Number of sashimi: {sashimi.x}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

