
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Add variables
x1 = m.addVar(vtype=GRB.INTEGER, name="milkshakes")
x2 = m.addVar(vtype=GRB.INTEGER, name="sashimi")

# Set the objective function
m.setObjective(7*x1 + 1*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(2*x1 + 12*x2 >= 31, "calcium_minimum")
m.addConstr(-6*x1 + 7*x2 >= 0, "sashimi_milkshake_ratio")
m.addConstr(2*x1 + 12*x2 <= 52, "total_calcium_limit")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Milkshakes: {x1.x}")
    print(f"Sashimi: {x2.x}")
else:
    print("No optimal solution found")
