
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define variables
    milkshakes = model.addVar(name='milkshakes', vtype=gurobi.GRB.INTEGER)
    sashimi = model.addVar(name='sashimi', vtype=gurobi.GRB.INTEGER)

    # Objective function: maximize 7 * milkshakes * sashimi
    # Since Gurobi does not directly support nonlinear objective functions in the standard API,
    # we will have to manipulate this. However, for simplicity and adherence to common practices,
    # let's approximate or directly tackle it with suitable methods.

    # However, the objective function 7 * milkshakes * sashimi is a product of two variables,
    # which makes it a nonlinear problem. Gurobi can handle this but requires a different approach.

    # For simplicity, let's reformulate it as a MILP if possible or use a suitable method.

    # Here, let's assume we are maximizing 7*milkshakes*sashimi directly might not be straightforward
    # We can use a piecewise or a big-M method for such problems but let's assume a direct formulation.

    model.setObjective(7 * milkshakes * sashimi, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(2 * milkshakes + 12 * sashimi >= 31)
    model.addConstr(-6 * milkshakes + 7 * sashimi >= 0)
    model.addConstr(2 * milkshakes + 12 * sashimi <= 52)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal Solution:")
        print(f"Milkshakes: {milkshakes.varValue}")
        print(f"Sashimi: {sashimi.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("The model is infeasible or unbounded.")

solve_optimization_problem()
