
import gurobipy as gp

# Create a new model
model = gp.Model("Minimize Labor Cost")

# Create variables
bobby_hours = model.addVar(vtype=gp.GRB.INTEGER, name="bobby_hours")
peggy_hours = model.addVar(vtype=gp.GRB.INTEGER, name="peggy_hours")
george_hours = model.addVar(vtype=gp.GRB.INTEGER, name="george_hours")


# Set objective function
model.setObjective(5 * bobby_hours + 8 * peggy_hours + 8 * george_hours, gp.GRB.MINIMIZE)

# Add constraints
model.addConstr(10 * peggy_hours + 26 * george_hours >= 99, "dollar_cost_peggy_george")
model.addConstr(13 * bobby_hours + 10 * peggy_hours >= 97, "dollar_cost_bobby_peggy")
model.addConstr(13 * bobby_hours + 10 * peggy_hours + 26 * george_hours >= 64, "dollar_cost_all")


model.addConstr(9 * peggy_hours + 6 * george_hours >= 68, "paperwork_peggy_george")
model.addConstr(8 * bobby_hours + 9 * peggy_hours >= 86, "paperwork_bobby_peggy")
model.addConstr(8 * bobby_hours + 6 * george_hours >= 41, "paperwork_bobby_george")
model.addConstr(8 * bobby_hours + 9 * peggy_hours + 6 * george_hours >= 41, "paperwork_all")

model.addConstr(-6 * bobby_hours + 4 * peggy_hours >= 0, "constraint_bobby_peggy")
model.addConstr(-7 * peggy_hours + 6 * george_hours >= 0, "constraint_peggy_george")

model.addConstr(8 * bobby_hours + 6 * george_hours <= 272, "paperwork_bobby_george_upper")
model.addConstr(9 * peggy_hours + 6 * george_hours <= 191, "paperwork_peggy_george_upper")



# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print('Optimal solution found:')
    print(f'Bobby hours: {bobby_hours.x}')
    print(f'Peggy hours: {peggy_hours.x}')
    print(f'George hours: {george_hours.x}')
    print(f'Objective value: {model.objVal}')
elif model.status == gp.GRB.INFEASIBLE:
    print('Model is infeasible.')
else:
    print(f'Optimization ended with status {model.status}.')

