
import gurobi as gp

# Define the model
m = gp.Model()

# Define the variables
x0 = m.addVar(name="x0", vtype=gp.GRB.INTEGER)  # hours worked by Bobby
x1 = m.addVar(name="x1", vtype=gp.GRB.INTEGER)  # hours worked by Peggy
x2 = m.addVar(name="x2", vtype=gp.GRB.INTEGER)  # hours worked by George

# Define the objective function
m.setObjective(5 * x0 + 8 * x1 + 8 * x2, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(10 * x1 + 26 * x2 >= 99)
m.addConstr(13 * x0 + 10 * x1 >= 97)
m.addConstr(13 * x0 + 10 * x1 + 26 * x2 >= 64)
m.addConstr(8 * x0 + 9 * x1 + 6 * x2 >= 68)
m.addConstr(8 * x0 + 9 * x1 >= 86)
m.addConstr(8 * x0 + 6 * x2 >= 41)
m.addConstr(8 * x0 + 9 * x1 + 6 * x2 >= 41)
m.addConstr(-6 * x0 + 4 * x1 >= 0)
m.addConstr(-7 * x1 + 6 * x2 >= 0)
m.addConstr(8 * x0 + 6 * x2 <= 272)
m.addConstr(9 * x1 + 6 * x2 <= 191)

# Optimize the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Hours worked by Bobby: {x0.varValue}")
    print(f"Hours worked by Peggy: {x1.varValue}")
    print(f"Hours worked by George: {x2.varValue}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found.")
