
import gurobipy as gp

# Create a new model
m = gp.Model("nutrition_optimization")

# Create variables
protein = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="protein")
vitamin_k = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_k")
vitamin_b4 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_b4")
vitamin_e = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_e")
fiber = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="fiber")


# Set objective function
m.setObjective(1*protein + 5*vitamin_k + 5*vitamin_b4 + 2*vitamin_e + 5*fiber, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(5 * protein + 9 * vitamin_k + 10 * vitamin_b4 + 10 * vitamin_e + 6 * fiber <= 263, "c0")
m.addConstr(12 * protein + 13 * vitamin_k + 4 * vitamin_b4 + 14 * vitamin_e + 7 * fiber <= 317, "c1")
m.addConstr(14 * protein + 3 * vitamin_k + 8 * vitamin_b4 + 5 * vitamin_e + 13 * fiber <= 316, "c2")

constraints = [
    (9*vitamin_k + 6*fiber >= 38, "c3"),
    (9*vitamin_k + 10*vitamin_e >= 35, "c4"),
    (9*vitamin_k + 10*vitamin_b4 >= 41, "c5"),
    (9*vitamin_k + 10*vitamin_b4 + 10*vitamin_e >= 47, "c6"),
    (10*vitamin_b4 + 10*vitamin_e + 6*fiber >= 47, "c7"),
    (9*vitamin_k + 10*vitamin_b4 + 6*fiber >= 47, "c8"),
    (5*protein + 9*vitamin_k + 10*vitamin_e >= 47, "c9"),
    # ... (rest of the constraints)
]

for constraint, name in constraints:
    m.addConstr(constraint, name)

# ... (rest of the constraints from the JSON)


m.addConstr(-10*vitamin_k + 5*vitamin_e >= 0, "c67")
m.addConstr(5*protein + 9*vitamin_k <= 210, "c68")
# ... (rest of the constraints)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible")
else:
    print("Optimization ended with status %d" % m.status)

