
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("vitamin_optimization")

    # Create variables
    vitamin_d = model.addVar(vtype=gp.GRB.INTEGER, name="vitamin_d")
    vitamin_b9 = model.addVar(vtype=gp.GRB.CONTINUOUS, name="vitamin_b9")
    zinc = model.addVar(vtype=gp.GRB.CONTINUOUS, name="zinc")


    # Set objective function
    model.setObjective(3.53 * vitamin_d + 5.16 * vitamin_b9 + 2.52 * zinc, gp.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(5 * vitamin_b9 + 11 * zinc >= 36, "c0")
    model.addConstr(5 * vitamin_d + 6 * vitamin_b9 + 11 * zinc >= 36, "c1")
    model.addConstr(1 * vitamin_d + 4 * vitamin_b9 >= 44, "c2")
    model.addConstr(1 * vitamin_d + 4 * vitamin_b9 + 2 * zinc >= 44, "c3")
    model.addConstr(2 * vitamin_d + 7 * vitamin_b9 >= 20, "c4")
    model.addConstr(2 * vitamin_d + 11 * zinc >= 33, "c5")
    model.addConstr(2 * vitamin_d + 7 * vitamin_b9 + 11 * zinc >= 33, "c6")
    model.addConstr(7 * vitamin_d - 10 * zinc >= 0, "c7")
    model.addConstr(9 * vitamin_b9 - 3 * zinc >= 0, "c8")
    model.addConstr(-5 * vitamin_d + 8 * vitamin_b9 >= 0, "c9")
    model.addConstr(5 * vitamin_d + 6 * vitamin_b9 <= 150, "c10")
    model.addConstr(2 * vitamin_d + 11 * zinc <= 164, "c11")
    model.addConstr(7 * vitamin_b9 + 11 * zinc <= 173, "c12")


    # Optimize model
    model.optimize()

    if model.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        print('vitamin_d:', vitamin_d.x)
        print('vitamin_b9:', vitamin_b9.x)
        print('zinc:', zinc.x)
    elif model.status == gp.GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % model.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
