
import gurobi

def optimize_problem():
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(name="x0", vtype=gurobi.GRB.INTEGER)  # milligrams of vitamin D
    x1 = model.addVar(name="x1")  # milligrams of vitamin B9
    x2 = model.addVar(name="x2")  # milligrams of zinc

    # Objective function
    model.setObjective(3.53 * x0 + 5.16 * x1 + 2.52 * x2, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(6 * x1 + 11 * x2 >= 36)
    model.addConstr(5 * x0 + 6 * x1 + 11 * x2 >= 36)
    model.addConstr(x0 + 4 * x1 >= 44)
    model.addConstr(x0 + 4 * x1 + 2 * x2 >= 44)
    model.addConstr(2 * x0 + 7 * x1 >= 20)
    model.addConstr(2 * x0 + 11 * x2 >= 33)
    model.addConstr(2 * x0 + 7 * x1 + 11 * x2 >= 33)
    model.addConstr(7 * x0 - 10 * x2 >= 0)
    model.addConstr(9 * x1 - 3 * x2 >= 0)
    model.addConstr(-5 * x0 + 8 * x1 >= 0)
    model.addConstr(5 * x0 + 6 * x1 <= 150)
    model.addConstr(2 * x0 + 11 * x2 <= 164)
    model.addConstr(7 * x1 + 11 * x2 <= 173)

    # Solve the problem
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Milligrams of vitamin D: {x0.varValue}")
        print(f"Milligrams of vitamin B9: {x1.varValue}")
        print(f"Milligrams of zinc: {x2.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

optimize_problem()
