
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_model")

    # Create variables
    x0 = m.addVar(name="grams_of_protein")
    x1 = m.addVar(name="milligrams_of_vitamin_B2")
    x2 = m.addVar(name="grams_of_carbohydrates")


    # Set objective function
    m.setObjective(1*x0 + 6*x1 + 2*x2, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(3.48*x0 + 0.04*x2 >= 28)
    m.addConstr(3.48*x0 + 3.43*x1 >= 34)
    m.addConstr(3.0*x0 + 3.44*x1 >= 25)
    m.addConstr(0.28*x0 + 2.49*x1 >= 54)
    m.addConstr(6*x1 - 5*x2 >= 0)
    m.addConstr(3.43*x1 + 0.04*x2 <= 129)
    m.addConstr(3.48*x0 + 0.04*x2 <= 176)
    m.addConstr(3.48*x0 + 3.43*x1 + 0.04*x2 <= 176)
    m.addConstr(3.44*x1 + 3.52*x2 <= 128)
    m.addConstr(3.0*x0 + 3.52*x2 <= 61)
    m.addConstr(3.0*x0 + 3.44*x1 + 3.52*x2 <= 61)
    m.addConstr(2.49*x1 + 1.22*x2 <= 157)
    m.addConstr(0.28*x0 + 2.49*x1 <= 79)
    m.addConstr(0.28*x0 + 2.49*x1 + 1.22*x2 <= 79)

    # Resource Constraints
    m.addConstr(3.48*x0 <= 202)
    m.addConstr(3.0*x0 <= 144)
    m.addConstr(0.28*x0 <= 201)
    m.addConstr(3.43*x1 <= 202)
    m.addConstr(3.44*x1 <= 144)
    m.addConstr(2.49*x1 <= 201)
    m.addConstr(0.04*x2 <= 202)
    m.addConstr(3.52*x2 <= 144)
    m.addConstr(1.22*x2 <= 201)


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Objective Value:', m.objVal)
        for v in m.getVars():
            print(f'{v.varName}: {v.x}')
    elif m.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization ended with status {m.status}")


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
