
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
x0 = m.addVar(name="x0", lb=0, ub=None)  # grams of protein
x1 = m.addVar(name="x1", lb=0, ub=None)  # milligrams of vitamin B2
x2 = m.addVar(name="x2", lb=0, ub=None)  # grams of carbohydrates

# Objective function
m.setObjective(x0 + 6 * x1 + 2 * x2, gurobi.GRB.MAXIMIZE)

# Constraints
m.addConstr(3.48 * x0 == 3.48, name="c1")
m.addConstr(3.0 * x0 == 3.0, name="c2")
m.addConstr(0.28 * x0 == 0.28, name="c3")
m.addConstr(3.43 * x1 == 3.43, name="c4")
m.addConstr(3.44 * x1 == 3.44, name="c5")
m.addConstr(2.49 * x1 == 2.49, name="c6")
m.addConstr(0.04 * x2 == 0.04, name="c7")
m.addConstr(3.52 * x2 == 3.52, name="c8")
m.addConstr(1.22 * x2 == 1.22, name="c9")
m.addConstr(3.48 * x0 + 0.04 * x2 >= 28, name="c10")
m.addConstr(3.48 * x0 + 3.43 * x1 >= 34, name="c11")
m.addConstr(3.0 * x0 + 3.44 * x1 >= 25, name="c12")
m.addConstr(0.28 * x0 + 2.49 * x1 >= 54, name="c13")
m.addConstr(6 * x1 - 5 * x2 >= 0, name="c14")
m.addConstr(3.43 * x1 + 0.04 * x2 <= 129, name="c15")
m.addConstr(3.48 * x0 + 0.04 * x2 <= 176, name="c16")
m.addConstr(3.48 * x0 + 3.43 * x1 + 0.04 * x2 <= 176, name="c17")
m.addConstr(3.44 * x1 + 3.52 * x2 <= 128, name="c18")
m.addConstr(3.0 * x0 + 3.52 * x2 <= 61, name="c19")
m.addConstr(3.0 * x0 + 3.44 * x1 + 3.52 * x2 <= 61, name="c20")
m.addConstr(2.49 * x1 + 1.22 * x2 <= 157, name="c21")
m.addConstr(0.28 * x0 + 2.49 * x1 <= 79, name="c22")
m.addConstr(0.28 * x0 + 2.49 * x1 + 1.22 * x2 <= 79, name="c23")

# Optimize the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("x0: ", x0.varValue)
    print("x1: ", x1.varValue)
    print("x2: ", x2.varValue)
else:
    print("The model is infeasible")
