
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("optimize_work_hours")

    # Create variables
    dale = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="dale")
    mary = model.addVar(lb=0, vtype=gp.GRB.INTEGER, name="mary")
    jean = model.addVar(lb=0, vtype=gp.GRB.INTEGER, name="jean")
    peggy = model.addVar(lb=0, vtype=gp.GRB.INTEGER, name="peggy")

    # Set objective function
    model.setObjective(3.77 * dale + 4.37 * mary + 2.05 * jean + 7.17 * peggy, gp.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(15 * dale + 23 * mary + 19 * peggy >= 96)
    model.addConstr(15 * dale + 6 * jean + 19 * peggy >= 96)
    model.addConstr(23 * mary + 6 * jean + 19 * peggy >= 96)
    model.addConstr(15 * dale + 23 * mary + 19 * peggy >= 93)
    model.addConstr(15 * dale + 6 * jean + 19 * peggy >= 93)
    model.addConstr(23 * mary + 6 * jean + 19 * peggy >= 93)
    model.addConstr(15 * dale + 23 * mary + 19 * peggy >= 105)
    model.addConstr(15 * dale + 6 * jean + 19 * peggy >= 105)
    model.addConstr(23 * mary + 6 * jean + 19 * peggy >= 105)
    model.addConstr(13 * dale + 2 * peggy >= 92)
    model.addConstr(13 * dale + 11 * mary >= 141)
    model.addConstr(15 * dale + 23 * mary <= 349)
    model.addConstr(6 * jean + 19 * peggy <= 464)
    model.addConstr(23 * mary + 19 * peggy <= 446)
    model.addConstr(15 * dale + 23 * mary + 19 * peggy <= 393)
    model.addConstr(15 * dale + 23 * mary + 6 * jean <= 484)
    model.addConstr(23 * mary + 6 * jean + 19 * peggy <= 176)
    model.addConstr(15 * dale + 6 * jean + 19 * peggy <= 215)
    model.addConstr(15 * dale + 23 * mary + 6 * jean + 19 * peggy <= 215)
    model.addConstr(13 * dale + 20 * jean <= 533)
    model.addConstr(20 * jean + 2 * peggy <= 396)
    model.addConstr(11 * mary + 2 * peggy <= 320)
    model.addConstr(13 * dale + 11 * mary + 2 * peggy <= 522)
    model.addConstr(13 * dale + 11 * mary + 20 * jean + 2 * peggy <= 522)


    # Optimize model
    model.optimize()

    if model.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        print('Dale: %g' % dale.x)
        print('Mary: %g' % mary.x)
        print('Jean: %g' % jean.x)
        print('Peggy: %g' % peggy.x)
    elif model.status == gp.GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % model.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
