
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
x0 = m.addVar(name='x0', lb=0)  # hours worked by Dale
x1 = m.addVar(name='x1', lb=0, integrality=gurobi.GRB.INTEGER)  # hours worked by Mary
x2 = m.addVar(name='x2', lb=0, integrality=gurobi.GRB.INTEGER)  # hours worked by Jean
x3 = m.addVar(name='x3', lb=0, integrality=gurobi.GRB.INTEGER)  # hours worked by Peggy

# Define the objective function
m.setObjective(3.77 * x0 + 4.37 * x1 + 2.05 * x2 + 7.17 * x3, gurobi.GRB.MAXIMIZE)

# Add constraints
m.addConstr(15 * x0 + 23 * x1 + 19 * x3 >= 96)
m.addConstr(15 * x0 + 6 * x2 + 19 * x3 >= 96)
m.addConstr(23 * x1 + 6 * x2 + 19 * x3 >= 96)
m.addConstr(15 * x0 + 23 * x1 + 19 * x3 >= 93)
m.addConstr(15 * x0 + 6 * x2 + 19 * x3 >= 93)
m.addConstr(23 * x1 + 6 * x2 + 19 * x3 >= 93)
m.addConstr(15 * x0 + 23 * x1 + 19 * x3 >= 105)
m.addConstr(15 * x0 + 6 * x2 + 19 * x3 >= 105)
m.addConstr(23 * x1 + 6 * x2 + 19 * x3 >= 105)
m.addConstr(13 * x0 + 2 * x3 >= 92)
m.addConstr(13 * x0 + 11 * x1 >= 141)
m.addConstr(15 * x0 + 23 * x1 <= 349)
m.addConstr(6 * x2 + 19 * x3 <= 464)
m.addConstr(23 * x1 + 19 * x3 <= 446)
m.addConstr(15 * x0 + 23 * x1 + 19 * x3 <= 393)
m.addConstr(15 * x0 + 23 * x1 + 6 * x2 <= 484)
m.addConstr(23 * x1 + 6 * x2 + 19 * x3 <= 176)
m.addConstr(15 * x0 + 6 * x2 + 19 * x3 <= 215)
m.addConstr(15 * x0 + 23 * x1 + 6 * x2 + 19 * x3 <= 215)
m.addConstr(13 * x0 + 20 * x2 <= 533)
m.addConstr(20 * x2 + 2 * x3 <= 396)
m.addConstr(11 * x1 + 2 * x3 <= 320)
m.addConstr(13 * x0 + 11 * x1 + 2 * x3 <= 522)
m.addConstr(13 * x0 + 11 * x1 + 20 * x2 + 2 * x3 <= 522)

# Optimize the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print('Objective: ', m.objVal)
    print('Hours worked by Dale: ', x0.varValue)
    print('Hours worked by Mary: ', x1.varValue)
    print('Hours worked by Jean: ', x2.varValue)
    print('Hours worked by Peggy: ', x3.varValue)
else:
    print('No optimal solution found')
