
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    model = gp.Model("optimization_problem")

    # Create variables
    x0 = model.addVar(vtype=GRB.INTEGER, name="reconnaissance_troops")
    x1 = model.addVar(vtype=GRB.INTEGER, name="engineer_platoons")


    # Set objective function
    model.setObjective(3*x0**2 + x1**2 + 4*x1, GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(1.36*x0 + 2.16*x1 >= 20, "c0")
    model.addConstr(4.77*x0 + 3.38*x1 >= 12, "c1")
    model.addConstr(3.67*x0 + 0.07*x1 >= 18, "c2")
    model.addConstr(0.4*x0**2 + 5.92*x1**2 >= 20, "c3")
    model.addConstr(5.77*x0**2 + 7.12*x1**2 >= 15, "c4")
    model.addConstr(2*x0 - 6*x1 >= 0, "c5")
    model.addConstr(1.36*x0 + 2.16*x1 <= 41, "c6")
    model.addConstr(4.77*x0 + 3.38*x1 <= 27, "c7")
    model.addConstr(3.67*x0 + 0.07*x1 <= 23, "c8")
    model.addConstr(0.4*x0 + 5.92*x1 <= 30, "c9")
    model.addConstr(5.77*x0 + 7.12*x1 <= 19, "c10")



    # Optimize model
    model.optimize()

    if model.status == GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        print('x0: %g' % x0.x)
        print('x1: %g' % x1.x)
    elif model.status == GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % model.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
