
import gurobi as gp

# Define the model
m = gp.Model()

# Define the variables
x0 = m.addVar(name="reconnaissance_troops", vtype=gp.GRB.INTEGER)
x1 = m.addVar(name="engineer_platoons", vtype=gp.GRB.INTEGER)

# Objective function
m.setObjective(3*x0**2 + x1**2 + 4*x1, gp.GRB.MAXIMIZE)

# Constraints
m.addConstr(1.36*x0 + 2.16*x1 >= 20)
m.addConstr(4.77*x0 + 3.38*x1 >= 12)
m.addConstr(3.67*x0 + 0.07*x1 >= 18)
m.addConstr(0.4*x0**2 + 5.92*x1**2 >= 20)
m.addConstr(5.77*x0**2 + 7.12*x1**2 >= 15)
m.addConstr(2*x0 - 6*x1 >= 0)
m.addConstr(1.36*x0 + 2.16*x1 <= 41)
m.addConstr(4.77*x0 + 3.38*x1 <= 27)
m.addConstr(3.67*x0 + 0.07*x1 <= 23)
m.addConstr(0.4*x0 + 5.92*x1 <= 30)
m.addConstr(5.77*x0 + 7.12*x1 <= 19)

# Optimize the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Reconnaissance troops: {x0.varValue}")
    print(f"Engineer platoons: {x1.varValue}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found.")
