
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="grams_of_fat")
    x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="milligrams_of_vitamin_B3")
    x2 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="grams_of_fiber")


    # Set objective function
    m.setObjective(6*x0**2 + 3*x0*x1 + 8*x0*x2 + 4*x1**2 + 3*x1*x2 + 9*x2**2 + 8*x0 + 8*x1 + 8*x2, GRB.MINIMIZE)

    # Add constraints
    m.addConstr(2*x0 + 8*x1 + 8*x2 >= 14, "c0")
    m.addConstr(5*x0 + 4*x1 + 1*x2 >= 7, "c1")
    m.addConstr(8*x1 + 8*x2 >= 14, "c2")
    m.addConstr(4*x1**2 + 1*x2**2 >= 5, "c3")
    m.addConstr(5*x0**2 + 1*x2**2 >= 7, "c4")
    m.addConstr(7*x0 - 5*x2 >= 0, "c5")

    # Resource constraints
    m.addConstr(2*x0 + 8*x1 + 8*x2 <= 74, "r0")
    m.addConstr(5*x0 + 4*x1 + 1*x2 <= 39, "r1")


    # Optimize model
    m.optimize()

    if m.status == GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('grams_of_fat:', x0.x)
        print('milligrams_of_vitamin_B3:', x1.x)
        print('grams_of_fiber:', x2.x)
    elif m.status == GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
