
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
x1 = m.addVar(name="x1", lb=0)  # grams of fat
x2 = m.addVar(name="x2", lb=0)  # milligrams of vitamin B3
x3 = m.addVar(name="x3", lb=0)  # grams of fiber

# Objective function
m.setObjective(6*x1**2 + 3*x1*x2 + 8*x1*x3 + 4*x2**2 + 3*x2*x3 + 9*x3**2 + 8*x1 + 8*x2 + 8*x3, gurobi.GRB.MINIMIZE)

# Constraints
m.addConstr(2*x1 <= 74)
m.addConstr(5*x1 <= 39)
m.addConstr(8*x2 <= 74)
m.addConstr(4*x2 <= 39)
m.addConstr(8*x3 <= 74)
m.addConstr(8*x2 + 8*x3 >= 14)
m.addConstr(2*x1 + 8*x2 + 8*x3 >= 14)
m.addConstr(4*x2**2 + x3**2 >= 5)
m.addConstr(5*x1**2 + x3**2 >= 7)
m.addConstr(5*x1 + 4*x2 + x3 >= 7)
m.addConstr(7*x1 - 5*x3 >= 0)

# Update model
m.update()

# Solve the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("x1: ", x1.varValue)
    print("x2: ", x2.varValue)
    print("x3: ", x3.varValue)
else:
    print("The model is infeasible")
