
from gurobipy import Model, GRB

# Create a new model
m = Model("carbohydrate_optimization")

# Create variables
potatoes = m.addVar(vtype=GRB.INTEGER, name="potatoes")
bananas = m.addVar(vtype=GRB.CONTINUOUS, name="bananas")

# Set objective function
m.setObjective(6 * potatoes + 7 * bananas, GRB.MINIMIZE)

# Add constraints
m.addConstr(2 * potatoes + 12 * bananas >= 39, "carbohydrate_minimum")
m.addConstr(-5 * potatoes + 7 * bananas >= 0, "potatoes_bananas_ratio")
m.addConstr(2 * potatoes + 12 * bananas <= 61, "carbohydrate_maximum")


# Optimize model
m.optimize()

# Check if a solution was found
if m.status == GRB.OPTIMAL:
    print('Optimal objective:', m.objVal)
    print('potatoes:', potatoes.x)
    print('bananas:', bananas.x)
elif m.status == GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print(f"Optimization ended with status {m.status}")

