
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Add variables to the model
x1 = m.addVar(vtype=GRB.INTEGER, name="potatoes")  # x1 represents potatoes and must be an integer
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="bananas")  # x2 represents bananas and can be a fraction

# Set the objective function to minimize
m.setObjective(6*x1 + 7*x2, GRB.MINIMIZE)

# Add constraints to the model
m.addConstr(2*x1 + 12*x2 >= 39, name="carbohydrates_min")  # Minimum carbohydrates constraint
m.addConstr(2*x1 + 12*x2 <= 61, name="carbohydrates_max")  # Maximum carbohydrates constraint
m.addConstr(-5*x1 + 7*x2 >= 0, name="potatoes_bananas_relationship")  # Relationship between potatoes and bananas

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution found: x1 = {x1.x}, x2 = {x2.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found")
