
import gurobi

# Create a new model
model = gurobi.Model()

# Define the variables
x1 = model.addVar(name="potatoes", vtype=gurobi.GRB.INTEGER)  # Integer variable for potatoes
x2 = model.addVar(name="bananas", vtype=gurobi.GRB.CONTINUOUS)  # Continuous variable for bananas

# Define the objective function
model.setObjective(6 * x1 + 7 * x2, gurobi.GRB.MINIMIZE)

# Add constraints
model.addConstr(2 * x1 + 12 * x2 >= 39, name="carbohydrates_min")
model.addConstr(2 * x1 + 12 * x2 <= 61, name="carbohydrates_max")
model.addConstr(-5 * x1 + 7 * x2 >= 0, name="potatoes_bananas_relationship")

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Potatoes: {x1.varValue}")
    print(f"Bananas: {x2.varValue}")
    print(f"Objective: {model.objVal}")
else:
    print("No optimal solution found.")
