
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
bill_hours = m.addVar(lb=0, name="bill_hours")
mary_hours = m.addVar(lb=0, name="mary_hours")
george_hours = m.addVar(lb=0, name="george_hours")
dale_hours = m.addVar(lb=0, name="dale_hours")


# Set objective function
m.setObjective(5*bill_hours**2 + 5*bill_hours*mary_hours + 1*bill_hours*george_hours + 4*bill_hours*dale_hours + 8*mary_hours**2 + 1*mary_hours*dale_hours + 4*george_hours**2 + 1*george_hours*dale_hours + 6*dale_hours**2 + 1*mary_hours + 1*george_hours + 7*dale_hours, GRB.MAXIMIZE)

# Add constraints
m.addConstr(15*bill_hours + 4*george_hours >= 47)
m.addConstr(15*bill_hours**2 + 9*dale_hours**2 >= 30)
m.addConstr(5*mary_hours + 4*george_hours >= 19)
m.addConstr(15*bill_hours + 5*mary_hours >= 50)
m.addConstr(15*bill_hours + 4*george_hours + 9*dale_hours >= 38)
m.addConstr(5*mary_hours + 4*george_hours + 9*dale_hours >= 38)
m.addConstr(15*bill_hours + 4*george_hours + 9*dale_hours >= 49)
m.addConstr(5*mary_hours + 4*george_hours + 9*dale_hours >= 49)
m.addConstr(1*bill_hours + 10*dale_hours >= 29)
m.addConstr(7*bill_hours + 12*mary_hours >= 59)
m.addConstr(12*mary_hours + 13*george_hours >= 35)
m.addConstr(7*bill_hours**2 + 13*george_hours**2 >= 41)
m.addConstr(13*george_hours**2 + 11*dale_hours**2 >= 31)
m.addConstr(7*bill_hours**2 + 12*mary_hours**2 + 11*dale_hours**2 >= 40)
m.addConstr(4*george_hours + 9*dale_hours <= 121)
m.addConstr(5*mary_hours + 9*dale_hours <= 142)
m.addConstr(15*bill_hours**2 + 4*george_hours**2 <= 80)
m.addConstr(15*bill_hours + 5*mary_hours + 9*dale_hours <= 63)
m.addConstr(15*bill_hours + 5*mary_hours + 4*george_hours + 9*dale_hours <= 63)
m.addConstr(1*bill_hours**2 + 14*george_hours**2 <= 164)
m.addConstr(1*bill_hours + 10*dale_hours <= 252)
m.addConstr(1*bill_hours + 14*george_hours + 10*dale_hours <= 261)
m.addConstr(1*bill_hours + 13*mary_hours + 14*george_hours <= 232)
m.addConstr(1*bill_hours + 13*mary_hours + 14*george_hours + 10*dale_hours <= 232)
m.addConstr(12*mary_hours + 11*dale_hours <= 158)
m.addConstr(7*bill_hours + 13*george_hours <= 84)
m.addConstr(13*george_hours + 11*dale_hours <= 215)
m.addConstr(7*bill_hours + 11*dale_hours <= 296)
m.addConstr(7*bill_hours + 12*mary_hours <= 220)
m.addConstr(12*mary_hours**2 + 13*george_hours**2 <= 162)
m.addConstr(7*bill_hours + 12*mary_hours + 13*george_hours + 11*dale_hours <= 162)
m.addConstr(13*bill_hours**2 + 1*mary_hours**2 <= 70)
m.addConstr(17*george_hours + 12*dale_hours <= 62)
m.addConstr(13*bill_hours**2 + 1*mary_hours**2 + 17*george_hours**2 <= 80)
m.addConstr(1*mary_hours + 17*george_hours + 12*dale_hours <= 48)
m.addConstr(13*bill_hours + 1*mary_hours + 17*george_hours + 12*dale_hours <= 48)


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == GRB.INFEASIBLE:
    print('Model is infeasible')
else:
    print('Optimization ended with status %d' % m.status)

