
import gurobi

# Define variables
m = gurobi.Model()
x0 = m.addVar(lb=-gurobi.GRB.INFINITY, name='x0')  # hours worked by Bill
x1 = m.addVar(lb=-gurobi.GRB.INFINITY, name='x1')  # hours worked by Mary
x2 = m.addVar(lb=-gurobi.GRB.INFINITY, name='x2')  # hours worked by George
x3 = m.addVar(lb=-gurobi.GRB.INFINITY, name='x3')  # hours worked by Dale

# Objective function
m.setObjective(5*x0**2 + 5*x0*x1 + x0*x2 + 4*x0*x3 + 8*x1**2 + x1*x3 + 4*x2**2 + x2*x3 + 6*x3**2 + x1 + x2 + 7*x3, gurobi.GRB.MAXIMIZE)

# Constraints
# Individual constraints
m.addConstr(15*x0 <= 212)
m.addConstr(x0 >= 0)
m.addConstr(1*x0 <= 304)
m.addConstr(7*x0 <= 320)
m.addConstr(13*x0 <= 153)

m.addConstr(5*x1 <= 212)
m.addConstr(13*x1 <= 304)
m.addConstr(12*x1 <= 320)
m.addConstr(x1 >= 0)

m.addConstr(4*x2 <= 212)
m.addConstr(14*x2 <= 304)
m.addConstr(13*x2 <= 320)
m.addConstr(17*x2 <= 153)

m.addConstr(9*x3 <= 212)
m.addConstr(10*x3 <= 304)
m.addConstr(11*x3 <= 320)
m.addConstr(12*x3 <= 153)

# Combined constraints
m.addConstr(15*x0 + 4*x2 >= 47)
m.addConstr(15*x0**2 + 9*x3**2 >= 30)
m.addConstr(5*x1 + 4*x2 >= 19)
m.addConstr(15*x0 + 5*x1 >= 50)
m.addConstr(15*x0 + 4*x2 + 9*x3 >= 38)
m.addConstr(5*x1 + 4*x2 + 9*x3 >= 38)
m.addConstr(15*x0 + 4*x2 + 9*x3 >= 49)
m.addConstr(5*x1 + 4*x2 + 9*x3 >= 49)

m.addConstr(1*x0 + 10*x3 >= 29)
m.addConstr(7*x0 + 12*x1 >= 59)
m.addConstr(12*x1 + 13*x2 >= 35)
m.addConstr(7*x0**2 + 13*x2**2 >= 41)
m.addConstr(13*x2**2 + 11*x3**2 >= 31)
m.addConstr(7*x0**2 + 12*x1**2 + 11*x3**2 >= 40)

m.addConstr(4*x2 + 9*x3 <= 121)
m.addConstr(5*x1 + 9*x3 <= 142)
m.addConstr(15*x0**2 + 4*x2**2 <= 80)
m.addConstr(15*x0 + 5*x1 + 9*x3 <= 63)
m.addConstr(15*x0 + 5*x1 + 4*x2 + 9*x3 <= 63)

m.addConstr(1*x0**2 + 14*x2**2 <= 164)
m.addConstr(1*x0 + 10*x3 <= 252)
m.addConstr(1*x0 + 14*x2 + 10*x3 <= 261)
m.addConstr(1*x0 + 13*x1 + 14*x2 <= 232)
m.addConstr(1*x0 + 13*x1 + 14*x2 + 10*x3 <= 232)

m.addConstr(12*x1 + 11*x3 <= 158)
m.addConstr(7*x0 + 13*x2 <= 84)
m.addConstr(13*x2 + 11*x3 <= 215)
m.addConstr(7*x0 + 11*x3 <= 296)
m.addConstr(7*x0 + 12*x1 <= 220)

m.addConstr(12*x1**2 + 13*x2**2 <= 162)
m.addConstr(7*x0 + 12*x1 + 13*x2 + 11*x3 <= 162)

m.addConstr(13*x0**2 + x1**2 <= 70)
m.addConstr(17*x2 + 12*x3 <= 62)
m.addConstr(13*x0**2 + x1**2 + 17*x2**2 <= 80)
m.addConstr(17*x2 + 12*x3 + x1 <= 48)
m.addConstr(13*x0 + x1 + 17*x2 + 12*x3 <= 48)

# Solve the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print('Objective: ', m.objVal)
    print('x0: ', x0.varValue)
    print('x1: ', x1.varValue)
    print('x2: ', x2.varValue)
    print('x3: ', x3.varValue)
else:
    print('No solution found')
