
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
knishes = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="knishes")
apples = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="apples")
chicken_drumsticks = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="chicken_drumsticks")


# Set objective function
m.setObjective(8.01*knishes**2 + 9.79*knishes*apples + 4.17*apples*chicken_drumsticks + 4.92*apples + 2.03*chicken_drumsticks, GRB.MINIMIZE)

# Add constraints
m.addConstr(26*knishes + 3*apples + 19*chicken_drumsticks >= 46, "c0")
m.addConstr(3*apples + 19*chicken_drumsticks >= 46, "c1")
m.addConstr(-4*knishes + 5*chicken_drumsticks >= 0, "c2")



# Optimize model
m.optimize()

# Check for infeasibility
if m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    # Print optimal solution
    print("Optimal solution found:")
    print(f"Knishes: {knishes.x}")
    print(f"Apples: {apples.x}")
    print(f"Chicken Drumsticks: {chicken_drumsticks.x}")
    print(f"Objective value: {m.objVal}")

