
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x1 = m.addVar(lb=0, name="knishes")  # Number of knishes
x2 = m.addVar(lb=0, name="apples")   # Quantity of apples
x3 = m.addVar(lb=0, name="chicken_drumsticks")  # Quantity of chicken drumsticks

# Set the objective function
m.setObjective(8.01*x1**2 + 9.79*x1*x2 + 4.17*x2*x3 + 4.92*x2 + 2.03*x3, GRB.MINIMIZE)

# Add constraints
m.addConstr(3*x2 + 19*x3 >= 46, name="healthiness_apples_chicken")
m.addConstr(26*x1 + 3*x2 + 19*x3 >= 46, name="total_healthiness")
m.addConstr(-4*x1 + 5*x3 >= 0, name="knishes_chicken_constraint")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Knishes: {x1.x}")
    print(f"Apples: {x2.x}")
    print(f"Chicken Drumsticks: {x3.x}")
else:
    print("No optimal solution found.")
