
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    knishes = model.addVar(name="knishes", lb=-gurobi.GRB.INFINITY)
    apples = model.addVar(name="apples", lb=-gurobi.GRB.INFINITY)
    chicken_drumsticks = model.addVar(name="chicken_drumsticks", lb=-gurobi.GRB.INFINITY)

    # Define the objective function
    model.setObjective(8.01 * knishes**2 + 9.79 * knishes * apples + 4.17 * apples * chicken_drumsticks + 4.92 * apples + 2.03 * chicken_drumsticks, gurobi.GRB.MINIMIZE)

    # Define the constraints
    model.addConstr(26 * knishes + 3 * apples + 19 * chicken_drumsticks >= 46)
    model.addConstr(3 * apples + 19 * chicken_drumsticks >= 46)
    model.addConstr(-4 * knishes + 5 * chicken_drumsticks >= 0)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Knishes: {knishes.varValue}")
        print(f"Apples: {apples.varValue}")
        print(f"Chicken Drumsticks: {chicken_drumsticks.varValue}")
        print(f"Objective Function Value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
