
import gurobipy as gp

# Create a new model
m = gp.Model("maximize_hours")

# Create variables
bill = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="bill")
john = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="john")
hank = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="hank")
dale = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="dale")
ringo = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="ringo")
bobby = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="bobby")


# Set objective
m.setObjective(1.47 * bill + 6.6 * john + 9.52 * hank + 7.99 * dale + 5.56 * ringo + 8.87 * bobby, gp.GRB.MAXIMIZE)

# Add constraints

m.addConstr(23.35 * bill + 0.72 * john + 3.99 * hank + 10.49 * dale + 7.84 * ringo + 9.36 * bobby <= 477)
m.addConstr(3.99 * hank + 7.84 * ringo >= 73)
m.addConstr(23.35 * bill + 7.84 * ringo >= 50)
m.addConstr(3.99 * hank + 10.49 * dale >= 63)
m.addConstr(23.35 * bill + 9.36 * bobby >= 49)
m.addConstr(23.35 * bill + 0.72 * john + 3.99 * hank >= 61)
m.addConstr(0.72 * john + 3.99 * hank + 9.36 * bobby >= 61)
m.addConstr(23.35 * bill + 3.99 * hank + 7.84 * ringo >= 61)
m.addConstr(23.35 * bill + 0.72 * john + 10.49 * dale >= 61)
m.addConstr(0.72 * john + 10.49 * dale + 7.84 * ringo >= 61)
m.addConstr(23.35 * bill + 10.49 * dale + 9.36 * bobby >= 61)
m.addConstr(23.35 * bill + 3.99 * hank + 10.49 * dale >= 61)
m.addConstr(0.72 * john + 3.99 * hank + 7.84 * ringo >= 61)


m.addConstr(0.72 * john + 9.36 * bobby <= 414)
m.addConstr(3.99 * hank + 7.84 * ringo <= 260)
m.addConstr(23.35 * bill + 0.72 * john <= 180)
m.addConstr(3.99 * hank + 10.49 * dale <= 141)
m.addConstr(0.72 * john + 10.49 * dale <= 436)
m.addConstr(7.84 * ringo + 9.36 * bobby <= 120)
m.addConstr(10.49 * dale + 7.84 * ringo <= 428)
m.addConstr(23.35 * bill + 3.99 * hank <= 109)
m.addConstr(0.72 * john + 3.99 * hank + 9.36 * bobby <= 214)
m.addConstr(23.35 * bill + 0.72 * john + 7.84 * ringo <= 211)
m.addConstr(0.72 * john + 10.49 * dale + 9.36 * bobby <= 437)
m.addConstr(0.72 * john + 7.84 * ringo + 9.36 * bobby <= 143)
m.addConstr(23.35 * bill + 3.99 * hank + 7.84 * ringo <= 259)
m.addConstr(23.35 * bill + 3.99 * hank + 10.49 * dale <= 427)
m.addConstr(0.72 * john + 3.99 * hank + 10.49 * dale <= 155)
m.addConstr(23.35 * bill + 0.72 * john + 3.99 * hank <= 123)
m.addConstr(0.72 * john + 10.49 * dale + 7.84 * ringo <= 187)
m.addConstr(10.49 * dale + 7.84 * ringo + 9.36 * bobby <= 313)
m.addConstr(23.35 * bill + 0.72 * john + 3.99 * hank + 10.49 * dale + 7.84 * ringo + 9.36 * bobby <= 313)



# Optimize model
m.optimize()

#print solution
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The problem is infeasible.")

