
import gurobipy as gp

# Create a new model
model = gp.Model("vitamin_optimization")

# Create variables
vitamin_d = model.addVar(vtype=gp.GRB.INTEGER, name="vitamin_d")
vitamin_b3 = model.addVar(vtype=gp.GRB.CONTINUOUS, name="vitamin_b3")
vitamin_c = model.addVar(vtype=gp.GRB.INTEGER, name="vitamin_c")
magnesium = model.addVar(vtype=gp.GRB.CONTINUOUS, name="magnesium")
vitamin_b9 = model.addVar(vtype=gp.GRB.INTEGER, name="vitamin_b9")


# Set objective function
model.setObjective(6.79 * vitamin_d + 5.12 * vitamin_b3 + 7.51 * vitamin_c + 3.45 * magnesium + 8.09 * vitamin_b9, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(5 * vitamin_d + 18 * vitamin_b3 + 21 * vitamin_c + 15 * magnesium + 20 * vitamin_b9 <= 884, "r0")
model.addConstr(9 * vitamin_d + 11 * vitamin_b3 + 12 * vitamin_c + 22 * magnesium + 26 * vitamin_b9 <= 638, "r1")
model.addConstr(17 * vitamin_d + 19 * vitamin_b3 + 19 * vitamin_c + 8 * magnesium + 6 * vitamin_b9 <= 181, "r2")

model.addConstr(21 * vitamin_c + 20 * vitamin_b9 >= 157)
model.addConstr(18 * vitamin_b3 + 21 * vitamin_c >= 82)
model.addConstr(15 * magnesium + 20 * vitamin_b9 >= 155)
model.addConstr(18 * vitamin_b3 + 15 * magnesium >= 117)
model.addConstr(5 * vitamin_d + 20 * vitamin_b9 >= 92)
model.addConstr(5 * vitamin_d + 15 * magnesium >= 103)
model.addConstr(5 * vitamin_d + 18 * vitamin_b3 >= 60)
model.addConstr(18 * vitamin_b3 + 20 * vitamin_b9 >= 161)
model.addConstr(5 * vitamin_d + 21 * vitamin_c >= 107)
model.addConstr(5 * vitamin_d + 18 * vitamin_b3 + 15 * magnesium >= 170)

# ... (add all other constraints similarly)
model.addConstr(19 * vitamin_b3 + 19 * vitamin_c <= 61)
model.addConstr(18 * vitamin_b3 + 21 * vitamin_c <= 441)
model.addConstr(18 * vitamin_b3 + 15 * magnesium <= 251)
model.addConstr(18 * vitamin_b3 + 20 * vitamin_b9 <= 626)



# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    for v in model.getVars():
        print('%s %g' % (v.varName, v.x))
elif model.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible")
else:
    print("Model status:", model.status)

