
import gurobi as gp

# Define the model
m = gp.Model()

# Define the variables
x1 = m.addVar(name="x1", vtype=gp.GRB.INTEGER)  # milligrams of vitamin D
x2 = m.addVar(name="x2")  # milligrams of vitamin B3
x3 = m.addVar(name="x3", vtype=gp.GRB.INTEGER)  # milligrams of vitamin C
x4 = m.addVar(name="x4")  # milligrams of magnesium
x5 = m.addVar(name="x5", vtype=gp.GRB.INTEGER)  # milligrams of vitamin B9

# Objective function
m.setObjective(6.79 * x1 + 5.12 * x2 + 7.51 * x3 + 3.45 * x4 + 8.09 * x5, gp.GRB.MAXIMIZE)

# Constraints
m.addConstr(5 * x1 <= 884)
m.addConstr(18 * x2 <= 884)
m.addConstr(21 * x3 <= 884)
m.addConstr(15 * x4 <= 884)
m.addConstr(20 * x5 <= 884)
m.addConstr(21 * x3 + 20 * x5 >= 157)
m.addConstr(18 * x2 + 21 * x3 >= 82)
m.addConstr(15 * x4 + 20 * x5 >= 155)
m.addConstr(18 * x2 + 15 * x4 >= 117)
m.addConstr(5 * x1 + 20 * x5 >= 92)
m.addConstr(5 * x1 + 15 * x4 >= 103)
m.addConstr(5 * x1 + 18 * x2 >= 60)
m.addConstr(18 * x2 + 20 * x5 >= 161)
m.addConstr(5 * x1 + 21 * x3 >= 107)

# Add more constraints...

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Milligrams of vitamin D: {x1.varValue}")
    print(f"Milligrams of vitamin B3: {x2.varValue}")
    print(f"Milligrams of vitamin C: {x3.varValue}")
    print(f"Milligrams of magnesium: {x4.varValue}")
    print(f"Milligrams of vitamin B9: {x5.varValue}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found.")
